/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.component.componentDefinition.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.Activity;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.AnswerPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionModelUtility;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionPackage;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentSubNode;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentSubNodeObserver;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputHandler;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputPortLink;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.RequestHandler;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.RequestPortLink;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameterPackage;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParametersRef;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.CommunicationServiceUsageRealization;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.CoordinationExtensionPackage;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.CoordinationSlavePort;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.OperationModeBinding;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.PrivateOperationMode;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.PublicOperationMode;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.ActivationConstraints;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.DefaultPeriodicTimer;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.DefaultTrigger;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.PerformanceExtensionPackage;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.SeronetExtensionPackage;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.SupportedMiddleware;
import org.eclipse.smartmdsd.xtext.component.componentDefinition.validation.AbstractComponentDefinitionValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ComponentDefinitionValidator
extends AbstractComponentDefinitionValidator {
    protected static final String COMP_DEF_ISSUE_PREFIX = "org.xtext.component.componentDefinition.";
    public static final String DUPLICATE_ACTIVATION_CONSTRAINTS = "org.xtext.component.componentDefinition.DuplicateActivationConstraints";
    public static final String ACTIVATION_FREQUENCY_CONSTRAINT = "org.xtext.component.componentDefinition.ActivationFrequencyConstraint";
    public static final String DEFAULT_TIMED_TRIGGER_MIN_FREQUENCY = "org.xtext.component.componentDefinition.DefaultTimedTriggerMinFrequency";
    public static final String DEFAULT_TIMED_TRIGGER_MAX_FREQUENCY = "org.xtext.component.componentDefinition.DefaultTimedTriggerMaxFrequency";
    public static final String DUPLICATE_OPERATION_MODE_BINDING = "org.xtext.component.componentDefinition.DuplicateOperationModeBinding";
    public static final String ACTIVITY_OBSERVATION_CYLE = "org.xtext.component.componentDefinition.ActivityObservationCycle";
    public static final String NOT_USED_PRIVATE_OPERATION_MODE = "org.xtext.component.componentDefinition.NotUsedPrivateOperationMode";
    public static final String PRIVATE_OPERATION_MODE_NAME = "org.xtext.component.componentDefinition.PrivateOperationModeName";
    public static final String MULTIPLE_DEFAULT_OPERATION_MODES = "org.xtext.component.componentDefinition.MultipleDefaultOperationModes";
    public static final String DUPLICATE_PARAMETER_STRUCT = "org.xtext.component.componentDefinition.DuplicateParameterStruct";
    public static final String MATCHING_PARAMETER_STRUCT = "org.xtext.component.componentDefinition.MatchingParameterStruct";
    public static final String MULTIPLE_DEFAULT_MIDDLEWARES = "org.xtext.component.componentDefinition.MultipleDefaultMiddlewares";
    public static final String MULTIPLE_DEFAULT_TRIGGERS = "org.xtext.component.componentDefinition.MultipleDefaultTriggers";
    public static final String INPUT_HANDLER_LINK = "org.xtext.component.componentDefinition.InputHandlerLink";
    public static final String INCOMPLETE_COORDINATION_SLAVE_PORT = "org.xtext.component.componentDefinition.IncompleteCoordinationSlavePort";
    public static final String DUPLICATE_REALIZATIONS_COORDINATION_SLAVE_PORT = "org.xtext.component.componentDefinition.DuplicateRealizationsCoordinationSlavePort";
    public static final String MISSING_REQUEST_HANDLER = "org.xtext.component.componentDefinition.MissingRequestHandler";
    public static final String PASSIVE_REQUEST_HANDLER = "org.xtext.component.componentDefinition.PassiveRequestHandler";

    @Check
    public void checkDuplicateActivationConstraints(ActivationConstraints act) {
        EObject parent = act.eContainer();
        if (parent instanceof Activity) {
            boolean _greaterThan;
            int _size = IterableExtensions.size((Iterable)Iterables.filter((Iterable)((Activity)parent).getExtensions(), ActivationConstraints.class));
            boolean bl = _greaterThan = _size > 1;
            if (_greaterThan) {
                this.error("Multiple ActivationConstraints-elements found, but (at most) one per Activity is allowed.", null, DUPLICATE_ACTIVATION_CONSTRAINTS, new String[0]);
            }
        }
    }

    @Check
    public void checkMinActFreqSmallerMaxActFreq(ActivationConstraints ac) {
        if (ac.getMaxActFreq() > 0.0 && ac.getMinActFreq() > ac.getMaxActFreq()) {
            this.warning("Activation minimal-frequency should be smaller or equal to the maximal-frequency", (EStructuralFeature)PerformanceExtensionPackage.Literals.ACTIVATION_CONSTRAINTS__MIN_ACT_FREQ, ACTIVATION_FREQUENCY_CONSTRAINT, new String[0]);
        }
    }

    @Check
    public void checkDefaultTimedTriggerFrequencyWithinActConstraints(DefaultPeriodicTimer timer) {
        EObject parent = timer.eContainer();
        if (parent instanceof Activity) {
            Iterable _filter = Iterables.filter((Iterable)((Activity)parent).getExtensions(), ActivationConstraints.class);
            for (ActivationConstraints act : _filter) {
                double _maxActFreq_1;
                boolean _greaterThan_2;
                double _maxActFreq;
                boolean _greaterThan_1;
                boolean _greaterThan;
                double _minActFreq = act.getMinActFreq();
                boolean bl = _greaterThan = _minActFreq > 0.0;
                if (_greaterThan) {
                    double _minActFreq_1;
                    boolean _lessThan;
                    double _periodicActFreq = timer.getPeriodicActFreq();
                    boolean bl2 = _lessThan = _periodicActFreq < (_minActFreq_1 = act.getMinActFreq());
                    if (_lessThan) {
                        String _string = Double.valueOf(act.getMinActFreq()).toString();
                        String _plus = "Chosen periodic activation-frequency is smaller than minimum frequency " + _string;
                        String _plus_1 = String.valueOf(_plus) + " defined in ActivationConstraints";
                        this.warning(_plus_1, (EStructuralFeature)PerformanceExtensionPackage.Literals.DEFAULT_PERIODIC_TIMER__PERIODIC_ACT_FREQ, DEFAULT_TIMED_TRIGGER_MIN_FREQUENCY, new String[]{Double.valueOf(act.getMinActFreq()).toString()});
                    }
                }
                boolean bl3 = _greaterThan_1 = (_maxActFreq = act.getMaxActFreq()) > 0.0;
                if (!_greaterThan_1) continue;
                double _periodicActFreq_1 = timer.getPeriodicActFreq();
                boolean bl4 = _greaterThan_2 = _periodicActFreq_1 > (_maxActFreq_1 = act.getMaxActFreq());
                if (!_greaterThan_2) continue;
                String _string_1 = Double.valueOf(act.getMaxActFreq()).toString();
                String _plus_2 = "Chosen periodic activation-frequency is higher than maximum frequency " + _string_1;
                String _plus_3 = String.valueOf(_plus_2) + " defined in ActivationConstraints";
                this.warning(_plus_3, (EStructuralFeature)PerformanceExtensionPackage.Literals.DEFAULT_PERIODIC_TIMER__PERIODIC_ACT_FREQ, DEFAULT_TIMED_TRIGGER_MAX_FREQUENCY, new String[]{Double.valueOf(act.getMaxActFreq()).toString()});
            }
        }
    }

    @Check
    public void checkDuplicateOperationModeBinding(OperationModeBinding state) {
        EObject parent = state.eContainer();
        if (parent instanceof Activity) {
            boolean _greaterThan;
            int _size = IterableExtensions.size((Iterable)Iterables.filter((Iterable)((Activity)parent).getExtensions(), OperationModeBinding.class));
            boolean bl = _greaterThan = _size > 1;
            if (_greaterThan) {
                this.error("Multiple OperationModeBinding-elements found, but (at most) one per Activity is allowed.", null, DUPLICATE_OPERATION_MODE_BINDING, new String[0]);
            }
        }
    }

    @Check
    public void checkNoActivityObserverCycle(ComponentSubNodeObserver observer) {
        boolean _contains;
        EObject parent = observer.eContainer();
        ComponentSubNode subject = observer.getSubject();
        if (subject instanceof Activity && (_contains = ComponentDefinitionModelUtility.getActivityObservationHierarchy((Activity)((Activity)subject)).contains(parent))) {
            String _name = ((Activity)subject).getName();
            String _plus = "Cycle in ActivityObservation of observed Activity " + _name;
            String _plus_1 = String.valueOf(_plus) + ".";
            this.error(_plus_1, (EStructuralFeature)ComponentDefinitionPackage.Literals.COMPONENT_SUB_NODE_OBSERVER__SUBJECT, ACTIVITY_OBSERVATION_CYLE, new String[0]);
        }
    }

    @Check
    public void checkPrivateOperationModeReferencedFromPublicOperationMode(PrivateOperationMode mode) {
        EObject parent = mode.eContainer();
        if (parent instanceof CoordinationSlavePort) {
            boolean _not;
            Functions.Function1 _function = it -> {
                Functions.Function1 _function_1 = it_1 -> Objects.equal((Object)it_1, (Object)mode);
                return IterableExtensions.exists((Iterable)it.getActivates(), (Functions.Function1)_function_1);
            };
            boolean _exists = IterableExtensions.exists((Iterable)Iterables.filter((Iterable)((CoordinationSlavePort)parent).getElements(), PublicOperationMode.class), (Functions.Function1)_function);
            boolean bl = _not = !_exists;
            if (_not) {
                String _name = mode.getName();
                String _plus = "PrivateOperationMode " + _name;
                String _plus_1 = String.valueOf(_plus) + " is not used by any PublicOperationMode.";
                this.warning(_plus_1, (EStructuralFeature)CoordinationExtensionPackage.Literals.PRIVATE_OPERATION_MODE__NAME, NOT_USED_PRIVATE_OPERATION_MODE, new String[]{mode.getName()});
            }
        }
    }

    @Check
    public void checkPrivateOperationModeNameBeginsWithSmallLetter(PrivateOperationMode mode) {
        boolean _not;
        boolean _isLowerCase = Character.isLowerCase(mode.getName().charAt(0));
        boolean bl = _not = !_isLowerCase;
        if (_not) {
            this.warning("PrivateOperationMode name should begin with a small letter.", (EStructuralFeature)CoordinationExtensionPackage.Literals.PRIVATE_OPERATION_MODE__NAME, PRIVATE_OPERATION_MODE_NAME, new String[]{mode.getName()});
        }
    }

    @Check
    public void checkSingleDefaultOperationMode(PublicOperationMode mode) {
        EObject parent = mode.eContainer();
        if (parent instanceof CoordinationSlavePort) {
            boolean _greaterThan;
            Functions.Function1 _function = it -> {
                boolean _isIsDefaultInit = it.isIsDefaultInit();
                return _isIsDefaultInit;
            };
            int _size = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((CoordinationSlavePort)parent).getElements(), PublicOperationMode.class), (Functions.Function1)_function));
            boolean bl = _greaterThan = _size > 1;
            if (_greaterThan) {
                this.warning("Multiple default PublicOperationModes are detected, but at most one is allowed.", (EStructuralFeature)CoordinationExtensionPackage.Literals.PUBLIC_OPERATION_MODE__IS_DEFAULT_INIT, MULTIPLE_DEFAULT_OPERATION_MODES, new String[0]);
            }
        }
    }

    @Check
    public void checkSingleParamStruct(ComponentParametersRef param) {
        EObject parent = param.eContainer();
        if (parent instanceof ComponentDefinition) {
            boolean _greaterThan;
            int _size = IterableExtensions.size((Iterable)Iterables.filter((Iterable)((ComponentDefinition)parent).getElements(), ComponentParametersRef.class));
            boolean bl = _greaterThan = _size > 1;
            if (_greaterThan) {
                this.error("Multiple ParameterStructs defined, but at most one is allowed.", (EStructuralFeature)ComponentParameterPackage.Literals.COMPONENT_PARAMETERS_REF__PARAMETER, DUPLICATE_PARAMETER_STRUCT, new String[0]);
            }
        }
    }

    @Check
    public void checkMatchingParamStruct(ComponentParametersRef param) {
        EObject component = param.eContainer();
        if (component instanceof ComponentDefinition) {
            boolean _not;
            boolean _equals = param.getParameter().getComponent().equals(component);
            boolean bl = _not = !_equals;
            if (_not) {
                this.warning("ParameterStruct is not using this component.", (EStructuralFeature)ComponentParameterPackage.Literals.COMPONENT_PARAMETERS_REF__PARAMETER, MATCHING_PARAMETER_STRUCT, new String[0]);
            }
        }
    }

    @Check
    public void checkSingleDefaultMiddleware(SupportedMiddleware mw) {
        EObject parent;
        boolean _isDefault = mw.isDefault();
        if (_isDefault && (parent = mw.eContainer()) instanceof ComponentPort) {
            Iterable _filter = Iterables.filter((Iterable)((ComponentPort)parent).getExtensions(), SupportedMiddleware.class);
            for (SupportedMiddleware other : _filter) {
                if (Objects.equal((Object)other, (Object)mw) || !other.isDefault()) continue;
                this.error("Multiple default middlewares are specified", (EStructuralFeature)SeronetExtensionPackage.Literals.SUPPORTED_MIDDLEWARE__DEFAULT, MULTIPLE_DEFAULT_MIDDLEWARES, new String[]{mw.eClass().getName()});
            }
        }
    }

    @Check
    public void checkSingleDefaultTrigger(DefaultTrigger trigger) {
        EObject parent = trigger.eContainer();
        if (parent instanceof Activity) {
            boolean _greaterThan;
            int _size = IterableExtensions.size((Iterable)Iterables.filter((Iterable)((Activity)parent).getExtensions(), DefaultTrigger.class));
            boolean bl = _greaterThan = _size > 1;
            if (_greaterThan) {
                this.error("Multiple default triggers are specified", null, MULTIPLE_DEFAULT_TRIGGERS, new String[0]);
            }
        }
    }

    @Check
    public void checkInputHandlerLink(InputPortLink link) {
        InputPort _inputPort_1;
        InputPort _inputPort;
        boolean _equals;
        EObject parent = link.eContainer();
        if (parent instanceof InputHandler && (_equals = Objects.equal((Object)(_inputPort = link.getInputPort()), (Object)(_inputPort_1 = ((InputHandler)parent).getInputPort())))) {
            this.error("InputLink cannot be the same as the InputHandler's input-trigger", (EStructuralFeature)ComponentDefinitionPackage.Literals.INPUT_PORT_LINK__INPUT_PORT, INPUT_HANDLER_LINK, new String[0]);
        }
    }

    @Check
    public void checkForMissingOptionalCoordinationSlaveRealization(CoordinationSlavePort slavePort) {
        int _size_1;
        boolean _notEquals;
        int _size = slavePort.getService().getServices().size();
        boolean bl = _notEquals = _size != (_size_1 = IterableExtensions.size((Iterable)Iterables.filter((Iterable)slavePort.getElements(), CommunicationServiceUsageRealization.class)));
        if (_notEquals) {
            this.warning("CoordinationSlavePort needs to realize all CommunicationServiceUsages.", (EStructuralFeature)CoordinationExtensionPackage.Literals.COORDINATION_SLAVE_PORT__ELEMENTS, INCOMPLETE_COORDINATION_SLAVE_PORT, new String[0]);
        }
    }

    @Check
    public void checkDuplicateOptionalCoordinationSlaveRealization(CommunicationServiceUsageRealization cServiceRealization) {
        EObject parent = cServiceRealization.eContainer();
        if (parent instanceof CoordinationSlavePort) {
            boolean _greaterThan;
            Functions.Function1 _function = it -> it.getServiceUsage().equals(cServiceRealization.getServiceUsage());
            int _size = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((CoordinationSlavePort)parent).getElements(), CommunicationServiceUsageRealization.class), (Functions.Function1)_function));
            boolean bl = _greaterThan = _size > 1;
            if (_greaterThan) {
                this.error("Duplicate realization of a CommunicationServiceUsage found, but exactly one realization is required.", (EStructuralFeature)CoordinationExtensionPackage.Literals.COMMUNICATION_SERVICE_USAGE_REALIZATION__SERVICE_USAGE, DUPLICATE_REALIZATIONS_COORDINATION_SLAVE_PORT, new String[0]);
            }
        }
    }

    @Check
    public void checkExistingRequestHandler(AnswerPort port) {
        EObject parent = port.eContainer();
        if (parent instanceof ComponentDefinition) {
            boolean _not;
            Functions.Function1 _function = it -> {
                AnswerPort _answerPort = it.getAnswerPort();
                return Objects.equal((Object)_answerPort, (Object)port);
            };
            boolean _exists = IterableExtensions.exists((Iterable)Iterables.filter((Iterable)((ComponentDefinition)parent).getElements(), RequestHandler.class), (Functions.Function1)_function);
            boolean bl = _not = !_exists;
            if (_not) {
                String _name = port.getName();
                String _plus = "No RequestHandler has been defined for the AnswerPort " + _name;
                this.warning(_plus, null, MISSING_REQUEST_HANDLER, new String[0]);
            }
        }
    }

    @Check
    public void checkRequestHandlerHasNoRequestPortLinks(RequestHandler handler) {
        if (!handler.isActiveQueue() && IterableExtensions.size((Iterable)Iterables.filter((Iterable)handler.getLinks(), RequestPortLink.class)) > 0) {
            this.warning("A passive request-handler actively initiates requests which can lead to deadlocks.", null, PASSIVE_REQUEST_HANDLER, new String[0]);
        }
    }
}

