/********************************************************************************
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 ********************************************************************************/
package org.eclipse.smartmdsd.xtext.service.parameterDefinition.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.ArrayType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.ArrayValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeRefinement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BasicAttributesPackage;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BoolValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.EnumerationElement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.EnumerationValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.FloatingPointValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.InlineEnumerationType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.IntValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.PrimitiveType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.StringValue;
import org.eclipse.smartmdsd.ecore.base.documentation.AbstractDocumentationElement;
import org.eclipse.smartmdsd.ecore.base.documentation.DocumentationPackage;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParamDefModel;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParamDefRepoImport;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterDefinition;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterDefinitionPackage;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterSetDefinition;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterSetRepository;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.TriggerDefinition;
import org.eclipse.smartmdsd.xtext.base.basicAttributes.serializer.BasicAttributesSemanticSequencer;
import org.eclipse.smartmdsd.xtext.service.parameterDefinition.services.ParameterDefinitionGrammarAccess;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class ParameterDefinitionSemanticSequencer extends BasicAttributesSemanticSequencer {

	@Inject
	private ParameterDefinitionGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == BasicAttributesPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case BasicAttributesPackage.ARRAY_TYPE:
				sequence_ArrayType(context, (ArrayType) semanticObject); 
				return; 
			case BasicAttributesPackage.ARRAY_VALUE:
				sequence_ArrayValue(context, (ArrayValue) semanticObject); 
				return; 
			case BasicAttributesPackage.ATTRIBUTE_DEFINITION:
				sequence_AttributeDefinition(context, (AttributeDefinition) semanticObject); 
				return; 
			case BasicAttributesPackage.ATTRIBUTE_REFINEMENT:
				sequence_AttributeRefinement(context, (AttributeRefinement) semanticObject); 
				return; 
			case BasicAttributesPackage.BOOL_VALUE:
				sequence_SingleValue(context, (BoolValue) semanticObject); 
				return; 
			case BasicAttributesPackage.ENUMERATION_ELEMENT:
				sequence_EnumerationElement(context, (EnumerationElement) semanticObject); 
				return; 
			case BasicAttributesPackage.ENUMERATION_VALUE:
				sequence_SingleValue(context, (EnumerationValue) semanticObject); 
				return; 
			case BasicAttributesPackage.FLOATING_POINT_VALUE:
				sequence_SingleValue(context, (FloatingPointValue) semanticObject); 
				return; 
			case BasicAttributesPackage.INLINE_ENUMERATION_TYPE:
				sequence_InlineEnumerationType(context, (InlineEnumerationType) semanticObject); 
				return; 
			case BasicAttributesPackage.INT_VALUE:
				sequence_SingleValue(context, (IntValue) semanticObject); 
				return; 
			case BasicAttributesPackage.PRIMITIVE_TYPE:
				sequence_PrimitiveType(context, (PrimitiveType) semanticObject); 
				return; 
			case BasicAttributesPackage.STRING_VALUE:
				sequence_SingleValue(context, (StringValue) semanticObject); 
				return; 
			}
		else if (epackage == DocumentationPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case DocumentationPackage.ABSTRACT_DOCUMENTATION_ELEMENT:
				sequence_AbstractDocumentationElement(context, (AbstractDocumentationElement) semanticObject); 
				return; 
			}
		else if (epackage == ParameterDefinitionPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case ParameterDefinitionPackage.PARAM_DEF_MODEL:
				sequence_ParamDefModel(context, (ParamDefModel) semanticObject); 
				return; 
			case ParameterDefinitionPackage.PARAM_DEF_REPO_IMPORT:
				sequence_ParamDefRepoImport(context, (ParamDefRepoImport) semanticObject); 
				return; 
			case ParameterDefinitionPackage.PARAMETER_DEFINITION:
				sequence_ParameterDefinition(context, (ParameterDefinition) semanticObject); 
				return; 
			case ParameterDefinitionPackage.PARAMETER_SET_DEFINITION:
				sequence_ParameterSetDefinition(context, (ParameterSetDefinition) semanticObject); 
				return; 
			case ParameterDefinitionPackage.PARAMETER_SET_REPOSITORY:
				sequence_ParameterSetRepository(context, (ParameterSetRepository) semanticObject); 
				return; 
			case ParameterDefinitionPackage.TRIGGER_DEFINITION:
				sequence_TriggerDefinition(context, (TriggerDefinition) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Contexts:
	 *     ParamDefModel returns ParamDefModel
	 *
	 * Constraint:
	 *     (imports+=ParamDefRepoImport* repository=ParameterSetRepository?)
	 */
	protected void sequence_ParamDefModel(ISerializationContext context, ParamDefModel semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ParamDefRepoImport returns ParamDefRepoImport
	 *
	 * Constraint:
	 *     importedNamespace=FQNW
	 */
	protected void sequence_ParamDefRepoImport(ISerializationContext context, ParamDefRepoImport semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, ParameterDefinitionPackage.Literals.PARAM_DEF_REPO_IMPORT__IMPORTED_NAMESPACE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ParameterDefinitionPackage.Literals.PARAM_DEF_REPO_IMPORT__IMPORTED_NAMESPACE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getParamDefRepoImportAccess().getImportedNamespaceFQNWParserRuleCall_1_0(), semanticObject.getImportedNamespace());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     AbstractParameter returns ParameterDefinition
	 *     ParameterDefinition returns ParameterDefinition
	 *
	 * Constraint:
	 *     (documentation=DOCU_COMMENT? name=ID attributes+=AttributeDefinition*)
	 */
	protected void sequence_ParameterDefinition(ISerializationContext context, ParameterDefinition semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ParameterSetDefinition returns ParameterSetDefinition
	 *
	 * Constraint:
	 *     (
	 *         documentation=DOCU_COMMENT? 
	 *         name=ID 
	 *         (extends+=[ParameterSetDefinition|FQN] extends+=[ParameterSetDefinition|FQN]*)? 
	 *         parameters+=AbstractParameter*
	 *     )
	 */
	protected void sequence_ParameterSetDefinition(ISerializationContext context, ParameterSetDefinition semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ParameterSetRepository returns ParameterSetRepository
	 *
	 * Constraint:
	 *     (documentation=DOCU_COMMENT? name=ID sets+=ParameterSetDefinition*)
	 */
	protected void sequence_ParameterSetRepository(ISerializationContext context, ParameterSetRepository semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AbstractParameter returns TriggerDefinition
	 *     TriggerDefinition returns TriggerDefinition
	 *
	 * Constraint:
	 *     (documentation=DOCU_COMMENT? name=ID attributes+=AttributeDefinition*)
	 */
	protected void sequence_TriggerDefinition(ISerializationContext context, TriggerDefinition semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
}
