/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.service.parameterDefinition.scoping;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterDefinitionPackage;
import org.eclipse.smartmdsd.xtext.indexer.XtextResourceIndex;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;

@SuppressWarnings("all")
public class ParameterDefinitionIndex extends XtextResourceIndex {
  public Iterable<IEObjectDescription> getVisibleParameterSetDescriptions(final EObject o) {
    return this.getVisibleEObjectDescriptions(o, ParameterDefinitionPackage.eINSTANCE.getParameterSetDefinition());
  }
  
  public Map<QualifiedName, IEObjectDescription> getVisibleExternalParameterSetDescriptions(final EObject o) {
    return this.getVisibleExternalDescriptions(o, ParameterDefinitionPackage.eINSTANCE.getParameterSetDefinition());
  }
}
