/**
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.base.genericDatasheet.ui;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.smartmdsd.datasheet.indexer.DatasheetProjectSettings;
import org.eclipse.smartmdsd.datasheet.indexer.WorkspaceDatasheetIndexer;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.AbstractDatasheetElement;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.DatasheetProperty;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.GenericDatasheetModel;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.MandatoryDatasheetElement;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.MandatoryDatasheetElementNames;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocumentProvider;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.osgi.service.prefs.Preferences;

@SuppressWarnings("all")
public class GenericDatasheetProjectPropertiesUpdater extends XtextDocumentProvider {
  @Override
  protected void doSaveDocument(final IProgressMonitor monitor, final Object element, final IDocument document, final boolean overwrite) throws CoreException {
    super.doSaveDocument(monitor, element, document, overwrite);
    if ((element instanceof FileEditorInput)) {
      final IProject project = ((FileEditorInput)element).getFile().getProject();
      if ((document instanceof IXtextDocument)) {
        ((IXtextDocument)document).<Object>readOnly(new IUnitOfWork<Object, XtextResource>() {
          @Override
          public Object exec(final XtextResource resource) throws Exception {
            GenericDatasheetProjectPropertiesUpdater.this.updateProjectProperties(resource, project);
            return resource;
          }
        });
      }
    }
  }
  
  public void updateProjectProperties(final XtextResource resource, final IProject project) {
    String _name = project.getName();
    String _plus = ("Update Datasheet project-settings for " + _name);
    final Job job = new Job(_plus) {
      @Override
      protected IStatus run(final IProgressMonitor monitor) {
        try {
          final WorkspaceDatasheetIndexer indexer = WorkspaceDatasheetIndexer.getInstance();
          final DatasheetProjectSettings settings = indexer.getDatasheetProjectSettings(project.getName());
          settings.clearAllMainProperties();
          int index = 0;
          Collection<AbstractDatasheetElement> _datasheetElements = GenericDatasheetProjectPropertiesUpdater.this.getDatasheetElements(resource);
          for (final AbstractDatasheetElement element : _datasheetElements) {
            if ((element instanceof MandatoryDatasheetElement)) {
              boolean _equals = ((MandatoryDatasheetElement)element).getName().equals(MandatoryDatasheetElementNames.SHORT_DESCRIPTION);
              if (_equals) {
                settings.setShortDescription(((MandatoryDatasheetElement)element).getValue());
              } else {
                final Preferences property_node = settings.getMainPropertyNode(((MandatoryDatasheetElement)element).getName().getLiteral());
                settings.updatePropertyValue(property_node, index, ((MandatoryDatasheetElement)element).getValue());
                index++;
              }
            } else {
              if ((element instanceof DatasheetProperty)) {
                final Preferences property_node_1 = settings.getMainPropertyNode(((DatasheetProperty)element).getName());
                settings.updatePropertyValue(property_node_1, index, ((DatasheetProperty)element).getValue(), ((DatasheetProperty)element).getUnit());
                String _semanticID = ((DatasheetProperty)element).getSemanticID();
                boolean _tripleNotEquals = (_semanticID != null);
                if (_tripleNotEquals) {
                  settings.updatePropertySeminticURI(property_node_1, index, ((DatasheetProperty)element).getSemanticID());
                }
                index++;
              } else {
                final String element_name = GenericDatasheetProjectPropertiesUpdater.this.getDatasheetElementName(element);
                boolean _equals_1 = element_name.equals("");
                boolean _not = (!_equals_1);
                if (_not) {
                  final Preferences custom_node = settings.getCustomSubNode(element_name);
                  custom_node.clear();
                  Collection<DatasheetProperty> _datasheetProperties = GenericDatasheetProjectPropertiesUpdater.this.getDatasheetProperties(element);
                  for (final DatasheetProperty property : _datasheetProperties) {
                    {
                      final Preferences property_node_2 = custom_node.node(property.getName());
                      settings.updatePropertyValue(property_node_2, index, property.getValue(), property.getUnit());
                      String _semanticID_1 = property.getSemanticID();
                      boolean _tripleNotEquals_1 = (_semanticID_1 != null);
                      if (_tripleNotEquals_1) {
                        settings.updatePropertySeminticURI(property_node_2, index, property.getSemanticID());
                      }
                      index++;
                    }
                  }
                }
              }
            }
          }
          settings.saveProperties();
          return Status.OK_STATUS;
        } catch (Throwable _e) {
          throw Exceptions.sneakyThrow(_e);
        }
      }
    };
    job.setRule(project);
    job.schedule();
  }
  
  public Collection<AbstractDatasheetElement> getDatasheetElements(final XtextResource resource) {
    final ArrayList<AbstractDatasheetElement> result = CollectionLiterals.<AbstractDatasheetElement>newArrayList();
    EList<EObject> _contents = resource.getContents();
    for (final EObject model : _contents) {
      if ((model instanceof GenericDatasheetModel)) {
        result.addAll(((GenericDatasheetModel)model).getElements());
      }
    }
    return result;
  }
  
  public String getDatasheetElementName(final AbstractDatasheetElement element) {
    return "";
  }
  
  public Collection<DatasheetProperty> getDatasheetProperties(final AbstractDatasheetElement element) {
    return CollectionLiterals.<DatasheetProperty>newArrayList();
  }
}
