/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.base.basicAttributes.ui.quickfix;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BasicAttributesTypeConformance;
import org.eclipse.smartmdsd.xtext.base.docuterminals.ui.quickfix.DocuTerminalsQuickfixProvider;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;

public class BasicAttributesQuickfixProvider
extends DocuTerminalsQuickfixProvider {
    @Inject
    private BasicAttributesTypeConformance conf;

    @Fix(value="org.xtext.service.communicationObject.SmallAttributeName")
    public void smallCaseName(Issue issue, IssueResolutionAcceptor acceptor) {
        IModification _function = context -> {
            IXtextDocument xtextDocument = context.getXtextDocument();
            String firstLetter = xtextDocument.get(issue.getOffset().intValue(), 1);
            xtextDocument.replace(issue.getOffset().intValue(), 1, firstLetter.toLowerCase());
        };
        acceptor.accept(issue, "Small-case name", "Small-case the name.", "", _function);
    }

    @Fix(value="org.xtext.service.communicationObject.IncompatibleTypes")
    public void createTypedDefaultValue(Issue issue, IssueResolutionAcceptor acceptor) {
        ISemanticModification _function = (element, context) -> {
            AttributeDefinition currAttribute = (AttributeDefinition)EcoreUtil2.getContainerOfType((EObject)element, AttributeDefinition.class);
            currAttribute.setDefaultvalue(this.conf.createPrimitiveDefaultValue(currAttribute.getType()));
        };
        acceptor.accept(issue, "Change to matching default value", "Change to matching default value type.", "", _function);
    }
}

