/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.base.basicAttributes.ui.contentassist;

import com.google.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.ArrayValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeRefinement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BasicAttributesModelUtility;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.PrimitiveType;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

/**
 * See https://www.eclipse.org/Xtext/documentation/310_eclipse_support.html#content-assist
 * on how to customize the content assistant.
 */
@SuppressWarnings("all")
public class BasicAttributesProposalProvider extends AbstractBasicAttributesProposalProvider {
  @Inject
  private BasicAttributesModelUtility util;
  
  @Override
  public void complete_AttributeDefinition(final EObject model, final RuleCall ruleCall, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    super.complete_AttributeDefinition(model, ruleCall, context, acceptor);
    if ((model instanceof AttributeDefinition)) {
      String _name = ((AttributeDefinition)model).getName();
      String _plus = (_name + " : ");
      String _typeName = this.util.getTypeName(((AttributeDefinition)model).getType());
      String proposalText = (_plus + _typeName);
      AbstractValue _defaultvalue = ((AttributeDefinition)model).getDefaultvalue();
      boolean _tripleNotEquals = (_defaultvalue != null);
      if (_tripleNotEquals) {
        String _proposalText = proposalText;
        String _valueString = this.util.getValueString(((AttributeDefinition)model).getDefaultvalue());
        String _plus_1 = (" = " + _valueString);
        proposalText = (_proposalText + _plus_1);
      }
      String _name_1 = ruleCall.getRule().getName();
      String _plus_2 = ("clone previous " + _name_1);
      acceptor.accept(this.createCompletionProposal(proposalText, _plus_2, this.getImage(model), context));
    }
  }
  
  @Override
  public void completeSingleValue_Value(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    EObject attr = model;
    if ((model instanceof ArrayValue)) {
      attr = ((ArrayValue)model).eContainer();
    }
    AbstractAttributeType attrType = null;
    if ((attr instanceof AttributeDefinition)) {
      attrType = ((AttributeDefinition)attr).getType();
    } else {
      if ((attr instanceof AttributeRefinement)) {
        attrType = ((AttributeRefinement)attr).getAttribute().getType();
        if ((attrType instanceof PrimitiveType)) {
          final AbstractValue defVal = ((AttributeRefinement)attr).getAttribute().getDefaultvalue();
          final String text = this.util.getValueString(defVal);
          if ((defVal != null)) {
            String _literal = ((PrimitiveType)attrType).getTypeName().getLiteral();
            String _plus = ((text + " - ") + _literal);
            acceptor.accept(this.createCompletionProposal(text, _plus, this.getImage(attrType), context));
          }
        }
      }
    }
    if ((attrType != null)) {
      final AbstractAttributeType type = attrType;
      final Iterable<String> textList = this.util.getDefaultValuesFor(attrType);
      final Consumer<String> _function = (String text_1) -> {
        String _typeName = this.util.getTypeName(type);
        String _plus_1 = ((text_1 + " - ") + _typeName);
        acceptor.accept(this.createCompletionProposal(text_1, _plus_1, this.getImage(type), context));
      };
      textList.forEach(_function);
    }
  }
}
