/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.internal.chart.defaultchartprovider;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.core.i18n.TimeZoneProvider;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.OpenClosedType;
import org.eclipse.smarthome.core.persistence.FilterCriteria;
import org.eclipse.smarthome.core.persistence.HistoricItem;
import org.eclipse.smarthome.core.persistence.PersistenceService;
import org.eclipse.smarthome.core.persistence.PersistenceServiceRegistry;
import org.eclipse.smarthome.core.persistence.QueryablePersistenceService;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.ui.chart.ChartProvider;
import org.eclipse.smarthome.ui.internal.chart.defaultchartprovider.ChartTheme;
import org.eclipse.smarthome.ui.internal.chart.defaultchartprovider.ChartThemeBlack;
import org.eclipse.smarthome.ui.internal.chart.defaultchartprovider.ChartThemeBright;
import org.eclipse.smarthome.ui.internal.chart.defaultchartprovider.ChartThemeDark;
import org.eclipse.smarthome.ui.internal.chart.defaultchartprovider.ChartThemeWhite;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.knowm.xchart.Chart;
import org.knowm.xchart.ChartBuilder;
import org.knowm.xchart.Series;
import org.knowm.xchart.SeriesMarker;
import org.knowm.xchart.StyleManager;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class DefaultChartProvider
implements ChartProvider {
    private final Logger logger = LoggerFactory.getLogger(DefaultChartProvider.class);
    private TimeZoneProvider timeZoneProvider;
    protected ItemUIRegistry itemUIRegistry;
    private PersistenceServiceRegistry persistenceServiceRegistry;
    private int legendPosition = 0;
    private static final ChartTheme[] CHART_THEMES_AVAILABLE = new ChartTheme[]{new ChartThemeWhite(), new ChartThemeBright(), new ChartThemeDark(), new ChartThemeBlack()};
    public static final String CHART_THEME_DEFAULT_NAME = "bright";
    private Map<String, ChartTheme> chartThemes = null;
    public static final int DPI_DEFAULT = 96;

    @Reference
    public void setItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = itemUIRegistry;
    }

    public void unsetItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = null;
    }

    @Reference
    protected void setPersistenceServiceRegistry(PersistenceServiceRegistry persistenceServiceRegistry) {
        this.persistenceServiceRegistry = persistenceServiceRegistry;
    }

    protected void unsetPersistenceServiceRegistry(PersistenceServiceRegistry persistenceServiceRegistry) {
        this.persistenceServiceRegistry = null;
    }

    @Reference
    public void setTimeZoneProvider(TimeZoneProvider timeZoneProvider) {
        this.timeZoneProvider = timeZoneProvider;
    }

    public void unsetTimeZoneProvider(TimeZoneProvider timeZoneProvider) {
        this.timeZoneProvider = null;
    }

    @Activate
    protected void activate() {
        this.logger.debug("Starting up default chart provider.");
        String themeNames = Arrays.stream(CHART_THEMES_AVAILABLE).map(t -> t.getThemeName()).collect(Collectors.joining(", "));
        this.logger.debug("Available themes for default chart provider: {}", (Object)themeNames);
    }

    @Override
    public String getName() {
        return "default";
    }

    @Override
    public BufferedImage createChart(String serviceId, String theme, Date startTime, Date endTime, int height, int width, String items, String groups, Integer dpiValue, Boolean legend) throws ItemNotFoundException, IllegalArgumentException {
        Item item;
        int n;
        int n2;
        String[] stringArray;
        this.logger.debug("Rendering chart: service: '{}', theme: '{}', startTime: '{}', endTime: '{}', width: '{}', height: '{}', items: '{}', groups: '{}', dpi: '{}', legend: '{}'", new Object[]{serviceId, theme, startTime, endTime, width, height, items, groups, dpiValue, legend});
        PersistenceService service = serviceId == null ? this.persistenceServiceRegistry.getDefault() : this.persistenceServiceRegistry.get(serviceId);
        QueryablePersistenceService persistenceService = service instanceof QueryablePersistenceService ? (QueryablePersistenceService)service : (QueryablePersistenceService)this.persistenceServiceRegistry.getAll().stream().filter(it -> it instanceof QueryablePersistenceService).findFirst().orElseThrow(() -> new IllegalArgumentException("No Persistence service found."));
        int seriesCounter = 0;
        ChartTheme chartTheme = this.getChartTheme(theme);
        int dpi = dpiValue != null && dpiValue > 0 ? dpiValue : 96;
        Chart chart = new ChartBuilder().width(width).height(height).build();
        long period = (endTime.getTime() - startTime.getTime()) / 1000L;
        String pattern = "HH:mm";
        pattern = period <= 600L ? "mm:ss" : (period <= 86400L ? "HH:mm" : (period <= 604800L ? "EEE d" : "d MMM"));
        chart.getStyleManager().setDatePattern(pattern);
        chart.getStyleManager().setAxisTickLabelsFont(chartTheme.getAxisTickLabelsFont(dpi));
        chart.getStyleManager().setAxisTickLabelsColor(chartTheme.getAxisTickLabelsColor());
        chart.getStyleManager().setXAxisMin((double)startTime.getTime());
        chart.getStyleManager().setXAxisMax((double)endTime.getTime());
        int yAxisSpacing = Math.max(height / 10, chartTheme.getAxisTickLabelsFont(dpi).getSize());
        chart.getStyleManager().setYAxisTickMarkSpacingHint(yAxisSpacing);
        chart.getStyleManager().setChartBackgroundColor(chartTheme.getChartBackgroundColor());
        chart.getStyleManager().setChartFontColor(chartTheme.getChartFontColor());
        chart.getStyleManager().setChartPadding(chartTheme.getChartPadding(dpi));
        chart.getStyleManager().setPlotBackgroundColor(chartTheme.getPlotBackgroundColor());
        float plotGridLinesDash = (float)chartTheme.getPlotGridLinesDash(dpi);
        float[] plotGridLinesDashArray = new float[]{plotGridLinesDash, plotGridLinesDash};
        chart.getStyleManager().setPlotGridLinesStroke((Stroke)new BasicStroke((float)chartTheme.getPlotGridLinesWidth(dpi), 0, 2, 10.0f, plotGridLinesDashArray, 0.0f));
        chart.getStyleManager().setPlotGridLinesColor(chartTheme.getPlotGridLinesColor());
        chart.getStyleManager().setLegendBackgroundColor(chartTheme.getLegendBackgroundColor());
        chart.getStyleManager().setLegendFont(chartTheme.getLegendFont(dpi));
        chart.getStyleManager().setLegendSeriesLineLength(chartTheme.getLegendSeriesLineLength(dpi));
        if (items != null) {
            String[] itemNames;
            stringArray = itemNames = items.split(",");
            n2 = itemNames.length;
            n = 0;
            while (n < n2) {
                String itemName = stringArray[n];
                item = this.itemUIRegistry.getItem(itemName);
                if (this.addItem(chart, persistenceService, startTime, endTime, item, seriesCounter, chartTheme, dpi)) {
                    ++seriesCounter;
                }
                ++n;
            }
        }
        if (groups != null) {
            String[] groupNames;
            stringArray = groupNames = groups.split(",");
            n2 = groupNames.length;
            n = 0;
            while (n < n2) {
                String groupName = stringArray[n];
                item = this.itemUIRegistry.getItem(groupName);
                if (item instanceof GroupItem) {
                    GroupItem groupItem = (GroupItem)item;
                    for (Item member : groupItem.getMembers()) {
                        if (!this.addItem(chart, persistenceService, startTime, endTime, member, seriesCounter, chartTheme, dpi)) continue;
                        ++seriesCounter;
                    }
                } else {
                    throw new ItemNotFoundException("Item '" + item.getName() + "' defined in groups is not a group.");
                }
                ++n;
            }
        }
        Boolean showLegend = null;
        if (seriesCounter == 0) {
            showLegend = false;
            ArrayList<Date> xData = new ArrayList<Date>();
            ArrayList<Integer> yData = new ArrayList<Integer>();
            xData.add(startTime);
            yData.add(0);
            xData.add(endTime);
            yData.add(0);
            Series series = chart.addSeries("NONE", xData, yData);
            series.setMarker(SeriesMarker.NONE);
            series.setLineStyle(new BasicStroke(0.0f));
        }
        if (showLegend == null) {
            showLegend = legend == null ? Boolean.valueOf(seriesCounter > 1) : legend;
        }
        if (showLegend.booleanValue()) {
            if (this.legendPosition < 0) {
                chart.getStyleManager().setLegendPosition(StyleManager.LegendPosition.InsideNW);
            } else {
                chart.getStyleManager().setLegendPosition(StyleManager.LegendPosition.InsideSW);
            }
        } else {
            chart.getStyleManager().setLegendVisible(false);
        }
        BufferedImage lBufferedImage = new BufferedImage(chart.getWidth(), chart.getHeight(), 2);
        Graphics2D lGraphics2D = lBufferedImage.createGraphics();
        chart.paint(lGraphics2D);
        return lBufferedImage;
    }

    double convertData(State state) {
        if (state instanceof DecimalType) {
            return ((DecimalType)state).doubleValue();
        }
        if (state instanceof OnOffType) {
            return state != OnOffType.OFF ? 1 : 0;
        }
        if (state instanceof OpenClosedType) {
            return state != OpenClosedType.CLOSED ? 1 : 0;
        }
        this.logger.debug("Unsupported item type in chart: {}", (Object)state.getClass().toString());
        return 0.0;
    }

    boolean addItem(Chart chart, QueryablePersistenceService service, Date timeBegin, Date timeEnd, Item item, int seriesCounter, ChartTheme chartTheme, int dpi) {
        Color color = chartTheme.getLineColor(seriesCounter);
        String label = null;
        if (this.itemUIRegistry != null && (label = this.itemUIRegistry.getLabel(item.getName())) != null && label.contains("[") && label.contains("]")) {
            label = label.substring(0, label.indexOf(91));
        }
        if (label == null) {
            label = item.getName();
        }
        ArrayList<Date> xData = new ArrayList<Date>();
        ArrayList<Number> yData = new ArrayList<Number>();
        State state = null;
        FilterCriteria filter = new FilterCriteria();
        filter.setEndDate(ZonedDateTime.ofInstant(timeBegin.toInstant(), this.timeZoneProvider.getTimeZone()));
        filter.setItemName(item.getName());
        filter.setPageSize(1);
        filter.setOrdering(FilterCriteria.Ordering.DESCENDING);
        Iterable result = service.query(filter);
        if (result.iterator().hasNext()) {
            HistoricItem historicItem = (HistoricItem)result.iterator().next();
            state = historicItem.getState();
            xData.add(timeBegin);
            yData.add(this.convertData(state));
        }
        filter.setBeginDate(ZonedDateTime.ofInstant(timeBegin.toInstant(), this.timeZoneProvider.getTimeZone()));
        filter.setEndDate(ZonedDateTime.ofInstant(timeEnd.toInstant(), this.timeZoneProvider.getTimeZone()));
        filter.setPageSize(Integer.MAX_VALUE);
        filter.setOrdering(FilterCriteria.Ordering.ASCENDING);
        result = service.query(filter);
        for (HistoricItem historicItem : result) {
            if (state instanceof OnOffType || state instanceof OpenClosedType) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(historicItem.getTimestamp());
                cal.add(14, -1);
                xData.add(cal.getTime());
                yData.add(this.convertData(state));
            }
            state = historicItem.getState();
            xData.add(historicItem.getTimestamp());
            yData.add(this.convertData(state));
        }
        if (state != null) {
            xData.add(timeEnd);
            yData.add(this.convertData(state));
        }
        if (xData.size() == 0) {
            return false;
        }
        if (xData.size() == 1) {
            xData.add((Date)xData.iterator().next());
            yData.add((Number)yData.iterator().next());
        }
        Series series = chart.addSeries(label, xData, yData);
        float lineWidth = (float)chartTheme.getLineWidth(dpi);
        series.setLineStyle(new BasicStroke(lineWidth, 1, 0));
        series.setMarker(SeriesMarker.NONE);
        series.setLineColor(color);
        this.legendPosition = (double)((Number)yData.iterator().next()).floatValue() > (series.getYMax() - series.getYMin()) / 2.0 + series.getYMin() ? ++this.legendPosition : --this.legendPosition;
        return true;
    }

    @Override
    public ChartProvider.ImageType getChartType() {
        return ChartProvider.ImageType.png;
    }

    private ChartTheme getChartTheme(String name) {
        ChartTheme chartTheme;
        if (this.chartThemes == null) {
            this.chartThemes = new HashMap<String, ChartTheme>();
            ChartTheme[] chartThemeArray = CHART_THEMES_AVAILABLE;
            int n = CHART_THEMES_AVAILABLE.length;
            int n2 = 0;
            while (n2 < n) {
                ChartTheme theme = chartThemeArray[n2];
                this.chartThemes.put(theme.getThemeName(), theme);
                ++n2;
            }
        }
        String chartThemeName = name;
        if (StringUtils.isBlank((String)name)) {
            chartThemeName = CHART_THEME_DEFAULT_NAME;
        }
        if ((chartTheme = this.chartThemes.get(chartThemeName)) == null) {
            chartTheme = this.chartThemes.get(CHART_THEME_DEFAULT_NAME);
        }
        return chartTheme;
    }
}

