/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.xml.internal;

import com.thoughtworks.xstream.converters.ConversionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.xml.AbstractXmlConfigDescriptionProvider;
import org.eclipse.smarthome.config.xml.osgi.XmlDocumentProvider;
import org.eclipse.smarthome.core.common.registry.Identifiable;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.xml.internal.ChannelGroupTypeXmlResult;
import org.eclipse.smarthome.core.thing.xml.internal.ChannelTypeXmlResult;
import org.eclipse.smarthome.core.thing.xml.internal.ThingTypeXmlResult;
import org.eclipse.smarthome.core.thing.xml.internal.XmlChannelGroupTypeProvider;
import org.eclipse.smarthome.core.thing.xml.internal.XmlChannelTypeProvider;
import org.eclipse.smarthome.core.thing.xml.internal.XmlThingTypeProvider;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThingTypeXmlProvider
implements XmlDocumentProvider<List<?>> {
    private final Logger logger = LoggerFactory.getLogger(ThingTypeXmlProvider.class);
    private final Bundle bundle;
    private final AbstractXmlConfigDescriptionProvider configDescriptionProvider;
    private final XmlThingTypeProvider thingTypeProvider;
    private final List<ThingTypeXmlResult> thingTypeRefs;
    private final List<ChannelGroupTypeXmlResult> channelGroupTypeRefs;
    private final List<ChannelTypeXmlResult> channelTypeRefs;
    private final XmlChannelTypeProvider channelTypeProvider;
    private final XmlChannelGroupTypeProvider channelGroupTypeProvider;

    public ThingTypeXmlProvider(Bundle bundle, AbstractXmlConfigDescriptionProvider configDescriptionProvider, XmlThingTypeProvider thingTypeProvider, XmlChannelTypeProvider channelTypeProvider, XmlChannelGroupTypeProvider channelGroupTypeProvider) throws IllegalArgumentException {
        if (bundle == null) {
            throw new IllegalArgumentException("The Bundle must not be null!");
        }
        if (configDescriptionProvider == null) {
            throw new IllegalArgumentException("The XmlConfigDescriptionProvider must not be null!");
        }
        if (thingTypeProvider == null) {
            throw new IllegalArgumentException("The XmlThingTypeProvider must not be null!");
        }
        this.bundle = bundle;
        this.configDescriptionProvider = configDescriptionProvider;
        this.thingTypeProvider = thingTypeProvider;
        this.channelTypeProvider = channelTypeProvider;
        this.channelGroupTypeProvider = channelGroupTypeProvider;
        this.thingTypeRefs = new ArrayList<ThingTypeXmlResult>(10);
        this.channelGroupTypeRefs = new ArrayList<ChannelGroupTypeXmlResult>(10);
        this.channelTypeRefs = new ArrayList<ChannelTypeXmlResult>(10);
    }

    public synchronized void addingObject(List<?> types) {
        if (types != null) {
            for (Object type : types) {
                Object typeResult;
                if (type instanceof ThingTypeXmlResult) {
                    typeResult = (ThingTypeXmlResult)type;
                    this.addConfigDescription(((ThingTypeXmlResult)typeResult).getConfigDescription());
                    this.thingTypeRefs.add((ThingTypeXmlResult)typeResult);
                    continue;
                }
                if (type instanceof ChannelGroupTypeXmlResult) {
                    typeResult = (ChannelGroupTypeXmlResult)type;
                    this.channelGroupTypeRefs.add((ChannelGroupTypeXmlResult)typeResult);
                    continue;
                }
                if (type instanceof ChannelTypeXmlResult) {
                    typeResult = (ChannelTypeXmlResult)type;
                    this.channelTypeRefs.add((ChannelTypeXmlResult)typeResult);
                    this.addConfigDescription(((ChannelTypeXmlResult)typeResult).getConfigDescription());
                    continue;
                }
                throw new ConversionException("Unknown data type for '" + type + "'!");
            }
        }
    }

    private void addConfigDescription(ConfigDescription configDescription) {
        if (configDescription != null) {
            try {
                this.configDescriptionProvider.add(this.bundle, (Identifiable)configDescription);
            }
            catch (Exception ex) {
                this.logger.error("Could not register ConfigDescription!", (Throwable)ex);
            }
        }
    }

    public synchronized void addingFinished() {
        HashMap<String, ChannelType> channelTypes = new HashMap<String, ChannelType>(10);
        for (ChannelTypeXmlResult channelTypeXmlResult : this.channelTypeRefs) {
            ChannelType channelType = channelTypeXmlResult.toChannelType();
            channelTypes.put(channelType.getUID().getAsString(), channelType);
            this.channelTypeProvider.add(this.bundle, (Identifiable)channelType);
        }
        for (ChannelGroupTypeXmlResult channelGroupTypeXmlResult : this.channelGroupTypeRefs) {
            this.channelGroupTypeProvider.add(this.bundle, (Identifiable)channelGroupTypeXmlResult.toChannelGroupType());
        }
        for (ThingTypeXmlResult thingTypeXmlResult : this.thingTypeRefs) {
            this.thingTypeProvider.add(this.bundle, (Identifiable)thingTypeXmlResult.toThingType());
        }
        this.thingTypeRefs.clear();
        this.channelGroupTypeRefs.clear();
        this.channelTypeRefs.clear();
    }

    public synchronized void release() {
        this.thingTypeProvider.removeAll(this.bundle);
        this.channelGroupTypeProvider.removeAll(this.bundle);
        this.channelTypeProvider.removeAll(this.bundle);
        this.configDescriptionProvider.removeAll(this.bundle);
    }
}

