/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.audio.internal;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.smarthome.core.audio.AudioException;
import org.eclipse.smarthome.core.audio.AudioManager;
import org.eclipse.smarthome.core.audio.AudioSink;
import org.eclipse.smarthome.core.audio.AudioSource;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.io.console.Console;
import org.eclipse.smarthome.io.console.extensions.AbstractConsoleCommandExtension;
import org.eclipse.smarthome.io.console.extensions.ConsoleCommandExtension;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConsoleCommandExtension.class})
public class AudioConsoleCommandExtension
extends AbstractConsoleCommandExtension {
    static final String SUBCMD_PLAY = "play";
    static final String SUBCMD_STREAM = "stream";
    static final String SUBCMD_SOURCES = "sources";
    static final String SUBCMD_SINKS = "sinks";
    private AudioManager audioManager;
    private LocaleProvider localeProvider;

    public AudioConsoleCommandExtension() {
        super("audio", "Commands around audio enablement features.");
    }

    public List<String> getUsages() {
        return Arrays.asList(this.buildCommandUsage("play [<sink>] <filename>", "plays a sound file from the sounds folder through the optionally specified audio sink(s)"), this.buildCommandUsage("play <sink> <filename> <volume>", "plays a sound file from the sounds folder through the specified audio sink(s) with the specified volume"), this.buildCommandUsage("stream [<sink>] <url>", "streams the sound from the url through the optionally specified audio sink(s)"), this.buildCommandUsage(SUBCMD_SOURCES, "lists the audio sources"), this.buildCommandUsage(SUBCMD_SINKS, "lists the audio sinks"));
    }

    public void execute(String[] args, Console console) {
        block22: {
            block20: {
                String subCommand;
                if (args.length <= 0) break block20;
                switch (subCommand = args[0]) {
                    case "play": {
                        if (args.length > 1) {
                            this.play((String[])ArrayUtils.subarray((Object[])args, (int)1, (int)args.length), console);
                        } else {
                            console.println("Specify file to play, and optionally the sink(s) to use (e.g. 'play javasound hello.mp3')");
                        }
                        return;
                    }
                    case "stream": {
                        if (args.length > 1) {
                            this.stream((String[])ArrayUtils.subarray((Object[])args, (int)1, (int)args.length), console);
                        } else {
                            console.println("Specify url to stream from, and optionally the sink(s) to use");
                        }
                        return;
                    }
                    case "sources": {
                        this.listSources(console);
                        return;
                    }
                    case "sinks": {
                        this.listSinks(console);
                        return;
                    }
                }
                break block22;
            }
            this.printUsage(console);
        }
    }

    private void listSources(Console console) {
        Set<AudioSource> sources = this.audioManager.getAllSources();
        if (sources.size() > 0) {
            AudioSource defaultSource = this.audioManager.getSource();
            Locale locale = this.localeProvider.getLocale();
            sources.stream().sorted(Comparator.comparing(s -> s.getLabel(locale))).forEach(source -> console.println(String.format("%s %s (%s)", source.equals(defaultSource) ? "*" : " ", source.getLabel(locale), source.getId())));
        } else {
            console.println("No audio sources found.");
        }
    }

    private void listSinks(Console console) {
        Set<AudioSink> sinks = this.audioManager.getAllSinks();
        if (sinks.size() > 0) {
            AudioSink defaultSink = this.audioManager.getSink();
            Locale locale = this.localeProvider.getLocale();
            sinks.stream().sorted(Comparator.comparing(s -> s.getLabel(locale))).forEach(sink -> console.println(String.format("%s %s (%s)", sink.equals(defaultSink) ? "*" : " ", sink.getLabel(locale), sink.getId())));
        } else {
            console.println("No audio sinks found.");
        }
    }

    private void play(String[] args, Console console) {
        switch (args.length) {
            case 1: {
                this.playOnSink(null, args[0], null, console);
                break;
            }
            case 2: {
                this.playOnSinks(args[0], args[1], null, console);
                break;
            }
            case 3: {
                PercentType volume = null;
                try {
                    volume = PercentType.valueOf((String)args[2]);
                }
                catch (Exception e) {
                    console.println(e.getMessage());
                    break;
                }
                this.playOnSinks(args[0], args[1], volume, console);
                break;
            }
        }
    }

    private void playOnSinks(String pattern, String fileName, PercentType volume, Console console) {
        for (String sinkId : this.audioManager.getSinkIds(pattern)) {
            this.playOnSink(sinkId, fileName, volume, console);
        }
    }

    private void playOnSink(String sinkId, String fileName, PercentType volume, Console console) {
        try {
            this.audioManager.playFile(fileName, sinkId, volume);
        }
        catch (AudioException e) {
            console.println(e.getMessage());
        }
    }

    private void stream(String[] args, Console console) {
        switch (args.length) {
            case 1: {
                this.streamOnSink(null, args[0], console);
                break;
            }
            case 2: {
                this.streamOnSinks(args[0], args[1], console);
                break;
            }
        }
    }

    private void streamOnSinks(String pattern, String url, Console console) {
        for (String sinkId : this.audioManager.getSinkIds(pattern)) {
            this.streamOnSink(sinkId, url, console);
        }
    }

    private void streamOnSink(String sinkId, String url, Console console) {
        try {
            this.audioManager.stream(url, sinkId);
        }
        catch (AudioException e) {
            console.println(e.getMessage());
        }
    }

    @Reference
    protected void setAudioManager(AudioManager audioManager) {
        this.audioManager = audioManager;
    }

    protected void unsetAudioManager(AudioManager audioManager) {
        this.audioManager = null;
    }

    @Reference
    protected void setLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    protected void unsetLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = null;
    }
}

