/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.audio;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.eclipse.smarthome.core.audio.AudioException;
import org.eclipse.smarthome.core.audio.AudioFormat;
import org.eclipse.smarthome.core.audio.AudioStream;
import org.eclipse.smarthome.core.audio.utils.AudioStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLAudioStream
extends AudioStream {
    private static final Pattern PLS_STREAM_PATTERN = Pattern.compile("^File[0-9]=(.+)$");
    public static final String M3U_EXTENSION = "m3u";
    public static final String PLS_EXTENSION = "pls";
    private final Logger logger = LoggerFactory.getLogger(URLAudioStream.class);
    private final AudioFormat audioFormat;
    private final InputStream inputStream;
    private String url;
    private Socket shoutCastSocket;

    public URLAudioStream(String url) throws AudioException {
        if (url == null) {
            throw new IllegalArgumentException("url must not be null!");
        }
        this.url = url;
        this.audioFormat = new AudioFormat("NONE", "MP3", false, 16, null, null);
        this.inputStream = this.createInputStream();
    }

    /*
     * Unable to fully structure code
     */
    private InputStream createInputStream() throws AudioException {
        filename = this.url.toLowerCase();
        extension = AudioStreamUtils.getExtension(filename);
        try {
            var3_3 = extension;
            tmp = -1;
            switch (var3_3.hashCode()) {
                case 106447: {
                    if (var3_3.equals("m3u")) {
                        tmp = 1;
                    }
                    break;
                }
                case 111095: {
                    if (var3_3.equals("pls")) {
                        tmp = 2;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    var4_6 = null;
                    var5_9 = null;
                    try {
                        isM3U = new URL(this.url).openStream();
                        try {
                            for (String line : IOUtils.readLines((InputStream)isM3U)) {
                                if (line.isEmpty() || line.startsWith("#")) continue;
                                this.url = line;
                                break;
                            }
                            if (isM3U == null) ** break;
                        }
                        catch (Throwable var4_7) {
                            if (isM3U != null) {
                                isM3U.close();
                            }
                            throw var4_7;
lbl37:
                            // 2 sources

                            break;
                        }
                        isM3U.close();
                        ** break;
                    }
                    catch (Throwable var5_10) {
                        if (var4_6 == null) {
                            var4_6 = var5_10;
                        } else if (var4_6 != var5_10) {
                            var4_6.addSuppressed(var5_10);
                        }
                        throw var4_6;
                    }
                }
                case 2: {
                    var4_6 = null;
                    var5_9 = null;
                    try {
                        isPLS = new URL(this.url).openStream();
                        try {
                            for (String line : IOUtils.readLines((InputStream)isPLS)) {
                                if (line.isEmpty() || !line.startsWith("File") || !(matcher = URLAudioStream.PLS_STREAM_PATTERN.matcher(line)).find()) continue;
                                this.url = matcher.group(1);
                                break;
                            }
                            if (isPLS == null) ** break;
                        }
                        catch (Throwable var4_8) {
                            if (isPLS != null) {
                                isPLS.close();
                            }
                            throw var4_8;
lbl62:
                            // 2 sources

                            break;
                        }
                        isPLS.close();
                        ** break;
                    }
                    catch (Throwable var5_11) {
                        if (var4_6 == null) {
                            var4_6 = var5_11;
                        } else if (var4_6 != var5_11) {
                            var4_6.addSuppressed(var5_11);
                        }
                        throw var4_6;
                    }
                }
            }
            streamUrl = new URL(this.url);
            connection = streamUrl.openConnection();
            if (connection.getContentType().equals("unknown/unknown")) {
                port = streamUrl.getPort() > 0 ? streamUrl.getPort() : 80;
                this.shoutCastSocket = new Socket(streamUrl.getHost(), port);
                os = this.shoutCastSocket.getOutputStream();
                userAgent = "WinampMPEG/5.09";
                req = "GET / HTTP/1.0\r\nuser-agent: " + userAgent + "\r\nIcy-MetaData: 1\r\nConnection: keep-alive\r\n\r\n";
                os.write(req.getBytes());
                return this.shoutCastSocket.getInputStream();
            }
            return connection.getInputStream();
        }
        catch (MalformedURLException e) {
            this.logger.error("URL '{}' is not a valid url: {}", new Object[]{this.url, e.getMessage(), e});
            throw new AudioException("URL not valid");
        }
        catch (IOException e) {
            this.logger.error("Cannot set up stream '{}': {}", new Object[]{this.url, e.getMessage(), e});
            throw new AudioException("IO Error");
        }
    }

    @Override
    public AudioFormat getFormat() {
        return this.audioFormat;
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    public String getURL() {
        return this.url;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.shoutCastSocket != null) {
            this.shoutCastSocket.close();
        }
    }

    public String toString() {
        return this.url;
    }
}

