/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.xml.util;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConverterValueMap {
    private HierarchicalStreamReader reader;
    private Map<String, Object> valueMap;
    private UnmarshallingContext context;

    public ConverterValueMap(HierarchicalStreamReader reader, UnmarshallingContext context) {
        this(reader, -1, context);
    }

    public ConverterValueMap(HierarchicalStreamReader reader, int numberOfValues, UnmarshallingContext context) throws ConversionException {
        this.reader = reader;
        this.context = context;
        this.valueMap = ConverterValueMap.readValueMap(this.reader, numberOfValues >= -1 ? numberOfValues : -1, this.context);
    }

    public Map<String, Object> getValueMap() {
        return this.valueMap;
    }

    public static Map<String, Object> readValueMap(HierarchicalStreamReader reader, int numberOfValues, UnmarshallingContext context) throws ConversionException {
        HashMap<String, Object> valueMap = new HashMap<String, Object>(numberOfValues >= 0 ? numberOfValues : 10);
        int counter = 0;
        while (reader.hasMoreChildren() && (counter < numberOfValues || numberOfValues == -1)) {
            reader.moveDown();
            if (reader.hasMoreChildren()) {
                List list = (List)context.convertAnother((Object)context, List.class);
                valueMap.put(reader.getNodeName(), list);
            } else {
                valueMap.put(reader.getNodeName(), reader.getValue());
            }
            reader.moveUp();
            ++counter;
        }
        if (counter < numberOfValues && numberOfValues > 0) {
            throw new ConversionException("Not all children could be read-in!");
        }
        return valueMap;
    }

    public Object getObject(String nodeName) {
        return this.valueMap.get(nodeName);
    }

    public Object getObject(String nodeName, Object defaultValue) {
        Object value = this.valueMap.get(nodeName);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public String getString(String nodeName) {
        return this.getString(nodeName, null);
    }

    public String getString(String nodeName, String defaultValue) {
        Object value = this.valueMap.get(nodeName);
        if (value instanceof String) {
            return ((String)value).replaceAll("\\n\\s*", " ").trim();
        }
        return defaultValue;
    }

    public Boolean getBoolean(String nodeName) {
        return this.getBoolean(nodeName, null);
    }

    public Boolean getBoolean(String nodeName, Boolean defaultValue) {
        Object value = this.valueMap.get(nodeName);
        if (value != null) {
            return Boolean.parseBoolean(value.toString());
        }
        return defaultValue;
    }

    public Integer getInteger(String nodeName) throws ConversionException {
        return this.getInteger(nodeName, null);
    }

    public Integer getInteger(String nodeName, Integer defaultValue) throws ConversionException {
        Object value = this.valueMap.get(nodeName);
        if (value != null) {
            try {
                return Integer.parseInt(value.toString());
            }
            catch (NumberFormatException nfe) {
                throw new ConversionException("The value '" + value + "' cannot be converted to a numeric value!", (Throwable)nfe);
            }
        }
        return defaultValue;
    }
}

