/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.xml.osgi;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.smarthome.config.xml.osgi.XmlDocumentProvider;
import org.eclipse.smarthome.config.xml.osgi.XmlDocumentProviderFactory;
import org.eclipse.smarthome.config.xml.util.XmlDocumentReader;
import org.eclipse.smarthome.core.common.ThreadPoolManager;
import org.eclipse.smarthome.core.service.ReadyMarker;
import org.eclipse.smarthome.core.service.ReadyService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlDocumentBundleTracker<T>
extends BundleTracker<Bundle> {
    public static final String THREAD_POOL_NAME = "file-processing";
    private final Logger logger = LoggerFactory.getLogger(XmlDocumentBundleTracker.class);
    private final ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"file-processing");
    private final String xmlDirectory;
    private final XmlDocumentReader<T> xmlDocumentTypeReader;
    private final XmlDocumentProviderFactory<T> xmlDocumentProviderFactory;
    private final Map<Bundle, XmlDocumentProvider<T>> bundleDocumentProviderMap = new ConcurrentHashMap<Bundle, XmlDocumentProvider<T>>();
    private final Map<Bundle, Future<?>> queue = new ConcurrentHashMap();
    private final Set<Bundle> finishedBundles = new CopyOnWriteArraySet<Bundle>();
    private final Map<String, ReadyMarker> bundleReadyMarkerRegistrations = new ConcurrentHashMap<String, ReadyMarker>();
    private final String readyMarkerKey;
    private final ReadWriteLock lockOpenState = new ReentrantReadWriteLock();
    private OpenState openState = OpenState.CREATED;
    private BundleTracker relevantBundlesTracker;
    private final ReadyService readyService;

    private static <T> T withLock(Lock lock, Supplier<T> supplier) {
        lock.lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    public XmlDocumentBundleTracker(BundleContext bundleContext, String xmlDirectory, XmlDocumentReader<T> xmlDocumentTypeReader, XmlDocumentProviderFactory<T> xmlDocumentProviderFactory, String readyMarkerKey, ReadyService readyService) throws IllegalArgumentException {
        super(bundleContext, 32, null);
        if (bundleContext == null) {
            throw new IllegalArgumentException("The BundleContext must not be null!");
        }
        if (xmlDirectory == null || xmlDirectory.isEmpty()) {
            throw new IllegalArgumentException("The XML directory must neither be null, nor empty!");
        }
        if (xmlDocumentTypeReader == null) {
            throw new IllegalArgumentException("The XmlDocumentTypeReader must not be null!");
        }
        if (xmlDocumentProviderFactory == null) {
            throw new IllegalArgumentException("The XmlDocumentProviderFactory must not be null!");
        }
        if (readyService == null) {
            throw new IllegalArgumentException("The ReadyService must not be null!");
        }
        this.readyMarkerKey = readyMarkerKey;
        this.xmlDirectory = xmlDirectory;
        this.xmlDocumentTypeReader = xmlDocumentTypeReader;
        this.xmlDocumentProviderFactory = xmlDocumentProviderFactory;
        this.readyService = readyService;
    }

    private boolean isBundleRelevant(Bundle bundle) {
        return this.isNotFragment(bundle) && this.isResourcePresent(bundle, this.xmlDirectory);
    }

    private boolean isNotFragment(Bundle bundle) {
        return bundle.getHeaders().get("Fragment-Host") == null;
    }

    private Set<Bundle> getRelevantBundles() {
        if (this.relevantBundlesTracker.getBundles() == null) {
            return Collections.emptySet();
        }
        return Arrays.stream(this.relevantBundlesTracker.getBundles()).collect(Collectors.toSet());
    }

    public final synchronized void open() {
        final OpenState openState = XmlDocumentBundleTracker.withLock(this.lockOpenState.writeLock(), () -> {
            if (this.openState == OpenState.CREATED) {
                this.openState = OpenState.OPENED;
            }
            return this.openState;
        });
        if (openState != OpenState.OPENED) {
            this.logger.warn("Open XML document bundle tracker forbidden (state: {})", (Object)openState);
            return;
        }
        this.relevantBundlesTracker = new BundleTracker(this.context, 60, null){

            public Object addingBundle(Bundle bundle, BundleEvent event) {
                return XmlDocumentBundleTracker.withLock(XmlDocumentBundleTracker.this.lockOpenState.readLock(), () -> openState == OpenState.OPENED && XmlDocumentBundleTracker.this.isBundleRelevant(bundle) ? bundle : null);
            }
        };
        this.relevantBundlesTracker.open();
        super.open();
    }

    public final synchronized void close() {
        XmlDocumentBundleTracker.withLock(this.lockOpenState.writeLock(), () -> {
            this.openState = OpenState.CLOSED;
            return this.openState;
        });
        this.clearQueue();
        super.close();
        this.unregisterReadyMarkers();
        this.bundleDocumentProviderMap.clear();
        if (this.relevantBundlesTracker != null) {
            this.relevantBundlesTracker.close();
        }
        this.finishedBundles.clear();
    }

    private void clearQueue() {
        for (Future<?> future : this.queue.values()) {
            future.cancel(true);
        }
        this.queue.clear();
    }

    private XmlDocumentProvider<T> acquireXmlDocumentProvider(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        XmlDocumentProvider<T> xmlDocumentProvider = this.bundleDocumentProviderMap.get(bundle);
        if (xmlDocumentProvider == null) {
            xmlDocumentProvider = this.xmlDocumentProviderFactory.createDocumentProvider(bundle);
            this.logger.trace("Create an empty XmlDocumentProvider for the module '{}'.", (Object)bundle.getSymbolicName());
            this.bundleDocumentProviderMap.put(bundle, xmlDocumentProvider);
        }
        return xmlDocumentProvider;
    }

    private void releaseXmlDocumentProvider(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        XmlDocumentProvider<T> xmlDocumentProvider = this.bundleDocumentProviderMap.get(bundle);
        if (xmlDocumentProvider == null) {
            return;
        }
        try {
            this.logger.debug("Releasing the XmlDocumentProvider for module '{}'.", (Object)bundle.getSymbolicName());
            xmlDocumentProvider.release();
        }
        catch (Exception e) {
            this.logger.error("Could not release the XmlDocumentProvider for '{}'!", (Object)bundle.getSymbolicName(), (Object)e);
        }
        this.bundleDocumentProviderMap.remove(bundle);
    }

    private void addingObject(Bundle bundle, T object) {
        XmlDocumentProvider<T> xmlDocumentProvider = this.acquireXmlDocumentProvider(bundle);
        if (xmlDocumentProvider != null) {
            xmlDocumentProvider.addingObject(object);
        }
    }

    private void addingFinished(Bundle bundle) {
        XmlDocumentProvider<T> xmlDocumentProvider = this.bundleDocumentProviderMap.get(bundle);
        if (xmlDocumentProvider == null) {
            return;
        }
        try {
            xmlDocumentProvider.addingFinished();
        }
        catch (Exception ex) {
            this.logger.error("Could not send adding finished event for the module '{}'!", (Object)bundle.getSymbolicName(), (Object)ex);
        }
    }

    public final synchronized Bundle addingBundle(Bundle bundle, BundleEvent event) {
        this.addingBundle(bundle);
        return bundle;
    }

    public final synchronized void removedBundle(Bundle bundle, BundleEvent event, Bundle object) {
        this.logger.trace("Removing the XML related objects from module '{}'...", (Object)bundle.getSymbolicName());
        this.finishedBundles.remove(bundle);
        Future<?> future = this.queue.remove(bundle);
        if (future != null) {
            future.cancel(true);
        }
        this.releaseXmlDocumentProvider(bundle);
        this.unregisterReadyMarker(bundle);
    }

    private Collection<URL> filterPatches(Enumeration<URL> xmlDocumentPaths, Bundle bundle) {
        ArrayList<URL> hostResources = new ArrayList<URL>();
        ArrayList<URL> fragmentResources = new ArrayList<URL>();
        while (xmlDocumentPaths.hasMoreElements()) {
            URL path = xmlDocumentPaths.nextElement();
            if (bundle.getEntry(path.getPath()) != null && bundle.getEntry(path.getPath()).equals(path)) {
                hostResources.add(path);
                continue;
            }
            fragmentResources.add(path);
        }
        if (!fragmentResources.isEmpty()) {
            HashMap<String, URL> helper = new HashMap<String, URL>();
            for (URL url : hostResources) {
                helper.put(url.getPath(), url);
            }
            for (URL url : fragmentResources) {
                helper.put(url.getPath(), url);
            }
            return helper.values();
        }
        return hostResources;
    }

    private final boolean isResourcePresent(Bundle bundle, String path) {
        return bundle.getEntry(path) != null;
    }

    private void addingBundle(final Bundle bundle) {
        if (XmlDocumentBundleTracker.withLock(this.lockOpenState.readLock(), () -> this.openState != OpenState.OPENED).booleanValue()) {
            return;
        }
        this.queue.put(bundle, this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                block3: {
                    if (((Boolean)XmlDocumentBundleTracker.withLock(XmlDocumentBundleTracker.this.lockOpenState.readLock(), () -> XmlDocumentBundleTracker.this.openState != OpenState.OPENED)).booleanValue()) {
                        return;
                    }
                    try {
                        XmlDocumentBundleTracker.this.processBundle(bundle);
                    }
                    catch (RuntimeException ex) {
                        if (!((Boolean)XmlDocumentBundleTracker.withLock(XmlDocumentBundleTracker.this.lockOpenState.readLock(), () -> XmlDocumentBundleTracker.this.openState == OpenState.OPENED)).booleanValue()) break block3;
                        throw ex;
                    }
                }
            }
        }));
    }

    private void finishBundle(Bundle bundle) {
        this.queue.remove(bundle);
        this.finishedBundles.add(bundle);
        this.registerReadyMarker(bundle);
        Set<Bundle> remainingBundles = this.getRemainingBundles();
        if (!remainingBundles.isEmpty()) {
            this.logger.trace("Remaining bundles with {}: {}", (Object)this.xmlDirectory, remainingBundles);
        } else {
            this.logger.trace("Finished loading bundles with {}", (Object)this.xmlDirectory);
            this.loadingCompleted();
        }
    }

    private Set<Bundle> getRemainingBundles() {
        return this.getRelevantBundles().stream().filter(b -> !this.finishedBundles.contains(b)).collect(Collectors.toSet());
    }

    private void processBundle(Bundle bundle) {
        Enumeration xmlDocumentPaths;
        if (this.isNotFragment(bundle) && (xmlDocumentPaths = bundle.findEntries(this.xmlDirectory, "*.xml", true)) != null) {
            Collection<URL> filteredPaths = this.filterPatches(xmlDocumentPaths, bundle);
            this.parseDocuments(bundle, filteredPaths);
        }
        this.finishBundle(bundle);
    }

    private void parseDocuments(Bundle bundle, Collection<URL> filteredPaths) {
        int numberOfParsedXmlDocuments = 0;
        for (URL xmlDocumentURL : filteredPaths) {
            String moduleName = bundle.getSymbolicName();
            String xmlDocumentFile = xmlDocumentURL.getFile();
            this.logger.debug("Reading the XML document '{}' in module '{}'...", (Object)xmlDocumentFile, (Object)moduleName);
            try {
                T object = this.xmlDocumentTypeReader.readFromXML(xmlDocumentURL);
                this.addingObject(bundle, object);
                ++numberOfParsedXmlDocuments;
            }
            catch (Exception ex) {
                if (XmlDocumentBundleTracker.withLock(this.lockOpenState.readLock(), () -> this.openState != OpenState.OPENED).booleanValue()) {
                    return;
                }
                this.logger.warn("The XML document '{}' in module '{}' could not be parsed: {}", new Object[]{xmlDocumentFile, moduleName, ex.getLocalizedMessage(), ex});
            }
        }
        if (numberOfParsedXmlDocuments > 0) {
            this.addingFinished(bundle);
        }
    }

    private void registerReadyMarker(Bundle bundle) {
        String bsn = bundle.getSymbolicName();
        if (!this.bundleReadyMarkerRegistrations.containsKey(bsn)) {
            ReadyMarker readyMarker = new ReadyMarker(this.readyMarkerKey, bsn);
            this.readyService.markReady(readyMarker);
            this.bundleReadyMarkerRegistrations.put(bsn, readyMarker);
        }
    }

    private void unregisterReadyMarker(Bundle bundle) {
        String bsn = bundle.getSymbolicName();
        ReadyMarker readyMarker = this.bundleReadyMarkerRegistrations.remove(bsn);
        if (readyMarker != null) {
            this.readyService.unmarkReady(readyMarker);
        }
    }

    private void unregisterReadyMarkers() {
        for (ReadyMarker readyMarker : this.bundleReadyMarkerRegistrations.values()) {
            this.readyService.unmarkReady(readyMarker);
        }
        this.bundleReadyMarkerRegistrations.clear();
    }

    private void loadingCompleted() {
    }

    public String toString() {
        return String.valueOf(super.toString()) + "(" + this.xmlDirectory + ")";
    }

    private static enum OpenState {
        CREATED,
        OPENED,
        CLOSED;

    }
}

