/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth;

import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.bluetooth.BluetoothAdapter;
import org.eclipse.smarthome.binding.bluetooth.BluetoothAddress;
import org.eclipse.smarthome.binding.bluetooth.BluetoothCharacteristic;
import org.eclipse.smarthome.binding.bluetooth.BluetoothCompletionStatus;
import org.eclipse.smarthome.binding.bluetooth.BluetoothDescriptor;
import org.eclipse.smarthome.binding.bluetooth.BluetoothDevice;
import org.eclipse.smarthome.binding.bluetooth.BluetoothDeviceListener;
import org.eclipse.smarthome.binding.bluetooth.notification.BluetoothConnectionStatusNotification;
import org.eclipse.smarthome.binding.bluetooth.notification.BluetoothScanNotification;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.thing.binding.BridgeHandler;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;

@NonNullByDefault
public class BeaconBluetoothHandler
extends BaseThingHandler
implements BluetoothDeviceListener {
    @NonNullByDefault(value={})
    protected BluetoothAdapter adapter;
    @NonNullByDefault(value={})
    protected BluetoothAddress address;
    @NonNullByDefault(value={})
    protected BluetoothDevice device;
    protected final ReentrantLock deviceLock = new ReentrantLock();

    public BeaconBluetoothHandler(Thing thing) {
        super(thing);
    }

    public void initialize() {
        try {
            this.address = new BluetoothAddress(this.getConfig().get("address").toString());
        }
        catch (IllegalArgumentException e) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, e.getLocalizedMessage());
            return;
        }
        Bridge bridge = this.getBridge();
        if (bridge == null) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "Not associated with any bridge");
            return;
        }
        BridgeHandler bridgeHandler = bridge.getHandler();
        if (!(bridgeHandler instanceof BluetoothAdapter)) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "Associated with an unsupported bridge");
            return;
        }
        this.adapter = (BluetoothAdapter)bridgeHandler;
        try {
            this.deviceLock.lock();
            this.device = this.adapter.getDevice(this.address);
            this.device.addListener(this);
        }
        finally {
            this.deviceLock.unlock();
        }
        this.updateStatus(ThingStatus.UNKNOWN);
    }

    public void dispose() {
        try {
            this.deviceLock.lock();
            if (this.device != null) {
                this.device.removeListener(this);
                this.device = null;
            }
        }
        finally {
            this.deviceLock.unlock();
        }
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        if (command == RefreshType.REFRESH && channelUID.getId().equals("rssi")) {
            this.updateRSSI();
        }
    }

    protected void updateRSSI() {
        if (this.device != null) {
            Integer rssi = this.device.getRssi();
            if (rssi != null && rssi != 0) {
                this.updateState("rssi", (State)new DecimalType((long)rssi.intValue()));
                this.updateStatusBasedOnRssi(true);
            } else {
                this.updateState("rssi", (State)UnDefType.NULL);
                this.updateStatusBasedOnRssi(false);
            }
        }
    }

    protected void updateStatusBasedOnRssi(boolean receivedSignal) {
        if (receivedSignal) {
            this.updateStatus(ThingStatus.ONLINE);
        } else {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR);
        }
    }

    @Override
    public void onScanRecordReceived(BluetoothScanNotification scanNotification) {
        int rssi = scanNotification.getRssi();
        if (rssi != Integer.MIN_VALUE) {
            this.device.setRssi(rssi);
            this.updateRSSI();
        }
    }

    @Override
    public void onConnectionStateChange(BluetoothConnectionStatusNotification connectionNotification) {
    }

    @Override
    public void onServicesDiscovered() {
    }

    @Override
    public void onCharacteristicReadComplete(BluetoothCharacteristic characteristic, BluetoothCompletionStatus status) {
    }

    @Override
    public void onCharacteristicWriteComplete(BluetoothCharacteristic characteristic, BluetoothCompletionStatus status) {
    }

    @Override
    public void onCharacteristicUpdate(BluetoothCharacteristic characteristic) {
    }

    @Override
    public void onDescriptorUpdate(BluetoothDescriptor bluetoothDescriptor) {
    }
}

