/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.astro.internal.job;

import org.eclipse.smarthome.binding.astro.handler.AstroThingHandler;
import org.eclipse.smarthome.binding.astro.internal.AstroHandlerFactory;
import org.eclipse.smarthome.binding.astro.internal.job.AbstractJob;
import org.eclipse.smarthome.binding.astro.internal.job.Job;

public final class EventJob
extends AbstractJob {
    private final String channelID;
    private final String event;

    public EventJob(String thingUID, String channelID, String event) {
        super(thingUID);
        EventJob.checkArgument(channelID != null, "The channelID must not be null");
        EventJob.checkArgument(event != null, "The event must not be null");
        this.channelID = channelID;
        this.event = event;
    }

    @Override
    public void run() {
        AstroThingHandler astroHandler = AstroHandlerFactory.getHandler(this.getThingUID());
        if (Job.checkNull(astroHandler, "AstroThingHandler is null")) {
            return;
        }
        astroHandler.triggerEvent(this.channelID, this.event);
    }

    public String toString() {
        return "Event job " + this.getThingUID() + "/" + this.channelID + "/" + this.event;
    }
}

