/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.thing.internal;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.ConfigDescriptionRegistry;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.common.registry.AbstractProvider;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.service.ReadyMarker;
import org.eclipse.smarthome.core.service.ReadyMarkerFilter;
import org.eclipse.smarthome.core.service.ReadyService;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingProvider;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.builder.BridgeBuilder;
import org.eclipse.smarthome.core.thing.binding.builder.ChannelBuilder;
import org.eclipse.smarthome.core.thing.binding.builder.ThingBuilder;
import org.eclipse.smarthome.core.thing.type.ChannelDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelKind;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.eclipse.smarthome.core.thing.type.ThingTypeRegistry;
import org.eclipse.smarthome.core.thing.type.TypeResolver;
import org.eclipse.smarthome.core.thing.util.ThingHelper;
import org.eclipse.smarthome.model.core.EventType;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.eclipse.smarthome.model.core.ModelRepositoryChangeListener;
import org.eclipse.smarthome.model.thing.thing.ModelBridge;
import org.eclipse.smarthome.model.thing.thing.ModelChannel;
import org.eclipse.smarthome.model.thing.thing.ModelProperty;
import org.eclipse.smarthome.model.thing.thing.ModelPropertyContainer;
import org.eclipse.smarthome.model.thing.thing.ModelThing;
import org.eclipse.smarthome.model.thing.thing.ThingModel;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericThingProvider
extends AbstractProvider<Thing>
implements ThingProvider,
ModelRepositoryChangeListener,
ReadyService.ReadyTracker {
    private static final String XML_THING_TYPE = "esh.xmlThingTypes";
    private LocaleProvider localeProvider;
    private ModelRepository modelRepository;
    private ThingTypeRegistry thingTypeRegistry;
    private Map<String, Collection<Thing>> thingsMap = new ConcurrentHashMap<String, Collection<Thing>>();
    private List<ThingHandlerFactory> thingHandlerFactories = new CopyOnWriteArrayList<ThingHandlerFactory>();
    private ConfigDescriptionRegistry configDescriptionRegistry;
    private final List<QueueContent> queue = new CopyOnWriteArrayList<QueueContent>();
    private Thread lazyRetryThread = null;
    private static final Logger logger = LoggerFactory.getLogger(GenericThingProvider.class);
    private final Set<String> loadedXmlThingTypes = new CopyOnWriteArraySet<String>();
    private final Runnable lazyRetryRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                logger.debug("Starting lazy retry thread");
                while (!GenericThingProvider.this.queue.isEmpty()) {
                    boolean _isEmpty_2;
                    boolean _not_2;
                    boolean _not;
                    boolean _isEmpty = GenericThingProvider.this.queue.isEmpty();
                    boolean bl = _not = !_isEmpty;
                    if (_not) {
                        boolean _not_1;
                        ArrayList<Thing> newThings = new ArrayList<Thing>();
                        Consumer<QueueContent> _function = qc -> {
                            boolean _notEquals;
                            logger.trace("Searching thingHandlerFactory for thingType: {}", (Object)((QueueContent)qc).thingTypeUID);
                            Thing thing = ((QueueContent)qc).thingHandlerFactory.createThing(((QueueContent)qc).thingTypeUID, ((QueueContent)qc).configuration, ((QueueContent)qc).thingUID, ((QueueContent)qc).bridgeUID);
                            boolean bl = _notEquals = !Objects.equal((Object)thing, null);
                            if (_notEquals) {
                                GenericThingProvider.this.queue.remove(qc);
                                logger.debug("Successfully loaded '{}' during retry", (Object)((QueueContent)qc).thingUID);
                                newThings.add(thing);
                            }
                        };
                        GenericThingProvider.this.queue.forEach(_function);
                        boolean _isEmpty_1 = newThings.isEmpty();
                        boolean bl2 = _not_1 = !_isEmpty_1;
                        if (_not_1) {
                            Consumer<Thing> _function_1 = newThing -> {
                                boolean _notEquals;
                                Functions.Function1 _function_2 = mName -> {
                                    Functions.Function1 _function_3 = it -> {
                                        ThingUID _uID = it.getUID();
                                        ThingUID _uID_1 = newThing.getUID();
                                        return Objects.equal((Object)_uID, (Object)_uID_1);
                                    };
                                    boolean _isEmpty_2 = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)((Iterable)GenericThingProvider.this.thingsMap.get(mName)), (Functions.Function1)_function_3));
                                    return !_isEmpty_2;
                                };
                                String modelName = (String)IterableExtensions.findFirst(GenericThingProvider.this.thingsMap.keySet(), (Functions.Function1)_function_2);
                                Functions.Function1 _function_3 = it -> {
                                    ThingUID _uID = it.getUID();
                                    ThingUID _uID_1 = newThing.getUID();
                                    return Objects.equal((Object)_uID, (Object)_uID_1);
                                };
                                Thing oldThing = (Thing)IterableExtensions.findFirst((Iterable)((Iterable)GenericThingProvider.this.thingsMap.get(modelName)), (Functions.Function1)_function_3);
                                boolean bl = _notEquals = !Objects.equal((Object)oldThing, null);
                                if (_notEquals) {
                                    boolean _not_2;
                                    GenericThingProvider.this.merge(newThing, oldThing);
                                    ((Collection)GenericThingProvider.this.thingsMap.get(modelName)).remove(oldThing);
                                    ((Collection)GenericThingProvider.this.thingsMap.get(modelName)).add(newThing);
                                    logger.debug("Refreshing thing '{}' after successful retry", (Object)newThing.getUID());
                                    boolean _equals = ThingHelper.equals((Thing)oldThing, (Thing)newThing);
                                    boolean bl2 = _not_2 = !_equals;
                                    if (_not_2) {
                                        GenericThingProvider.this.notifyListenersAboutUpdatedElement(oldThing, newThing);
                                    }
                                } else {
                                    String _format = String.format("Item %s not yet known", newThing.getUID());
                                    throw new IllegalStateException(_format);
                                }
                            };
                            newThings.forEach(_function_1);
                        }
                    }
                    boolean bl3 = _not_2 = !(_isEmpty_2 = GenericThingProvider.this.queue.isEmpty());
                    if (!_not_2) continue;
                    Thread.sleep(1000L);
                }
                logger.debug("Lazy retry thread ran out of work. Good bye.");
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    };

    public void activate() {
        Consumer<String> _function = it -> this.createThingsFromModel((String)it);
        this.modelRepository.getAllModelNamesOfType("things").forEach(_function);
    }

    public Collection<Thing> getAll() {
        return IterableExtensions.toList((Iterable)Iterables.concat(this.thingsMap.values()));
    }

    private void createThingsFromModel(String modelName) {
        boolean _notEquals;
        logger.debug("Read things from model '{}'", (Object)modelName);
        Collection<Thing> _get = this.thingsMap.get(modelName);
        boolean _equals = Objects.equal(_get, null);
        if (_equals) {
            this.thingsMap.put(modelName, CollectionLiterals.newArrayList((Object[])new Thing[0]));
        }
        boolean bl = _notEquals = !Objects.equal((Object)this.modelRepository, null);
        if (_notEquals) {
            EObject _model = this.modelRepository.getModel(modelName);
            ThingModel model = (ThingModel)_model;
            EList<ModelThing> _things = null;
            if (model != null) {
                _things = model.getThings();
            }
            List _map = null;
            if (_things != null) {
                Functions.Function1 _function = it -> {
                    boolean _notEquals_1;
                    ThingUID thingUID = this.constructThingUID((ModelThing)it);
                    boolean bl = _notEquals_1 = !Objects.equal((Object)thingUID, null);
                    if (_notEquals_1) {
                        ThingTypeUID thingTypeUID = this.constructThingTypeUID((ModelThing)it, thingUID);
                        Functions.Function1 _function_1 = it_1 -> it_1.supportsThingType(thingTypeUID);
                        return (ThingHandlerFactory)IterableExtensions.findFirst(this.thingHandlerFactories, (Functions.Function1)_function_1);
                    }
                    return null;
                };
                _map = ListExtensions.map(_things, (Functions.Function1)_function);
            }
            Iterable _filter = null;
            if (_map != null) {
                Functions.Function1 _function_1 = it -> !Objects.equal((Object)it, null);
                _filter = IterableExtensions.filter((Iterable)_map, (Functions.Function1)_function_1);
            }
            Set _set = null;
            if (_filter != null) {
                _set = IterableExtensions.toSet((Iterable)_filter);
            }
            if (_set != null) {
                Consumer<ThingHandlerFactory> _function_2 = it -> this.createThingsFromModelForThingHandlerFactory(modelName, (ThingHandlerFactory)it);
                _set.forEach(_function_2);
            }
        }
    }

    private ThingUID constructThingUID(ModelThing modelThing) {
        boolean _notEquals_1;
        boolean _notEquals;
        String _id = modelThing.getId();
        boolean bl = _notEquals = !Objects.equal((Object)_id, null);
        if (_notEquals) {
            String _id_1 = modelThing.getId();
            return new ThingUID(_id_1);
        }
        String _bridgeUID = modelThing.getBridgeUID();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_bridgeUID, null);
        if (_notEquals_1) {
            String _bridgeUID_1 = modelThing.getBridgeUID();
            String bindingId = new ThingUID(_bridgeUID_1).getBindingId();
            String _thingTypeId = modelThing.getThingTypeId();
            String _thingId = modelThing.getThingId();
            return new ThingUID(bindingId, _thingTypeId, _thingId);
        }
        logger.warn("Thing {} does not have a bridge so it needs to be defined in full notation like <bindingId>:{}:{}", new Object[]{modelThing.getThingTypeId(), modelThing.getThingTypeId(), modelThing.getThingId()});
        return null;
    }

    private ThingTypeUID constructThingTypeUID(ModelThing modelThing, ThingUID thingUID) {
        boolean _notEquals;
        String _thingTypeId = modelThing.getThingTypeId();
        boolean bl = _notEquals = !Objects.equal((Object)_thingTypeId, null);
        if (_notEquals) {
            String _bindingId = thingUID.getBindingId();
            String _thingTypeId_1 = modelThing.getThingTypeId();
            return new ThingTypeUID(_bindingId, _thingTypeId_1);
        }
        String _bindingId_1 = thingUID.getBindingId();
        String _thingTypeId_2 = thingUID.getThingTypeId();
        return new ThingTypeUID(_bindingId_1, _thingTypeId_2);
    }

    private void createThing(ModelThing modelThing, Bridge parentBridge, Collection<Thing> thingList, ThingHandlerFactory thingHandlerFactory) {
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _not;
        boolean _notEquals;
        ThingUID thingUID;
        boolean _equals;
        ThingUID _uID = null;
        if (parentBridge != null) {
            _uID = parentBridge.getUID();
        }
        if (_equals = Objects.equal((Object)(thingUID = this.getThingUID(modelThing, _uID)), null)) {
            return;
        }
        ThingTypeUID thingTypeUID = this.constructThingTypeUID(modelThing, thingUID);
        ThingUID bridgeUID = null;
        boolean bl = _notEquals = !Objects.equal((Object)parentBridge, null);
        if (_notEquals) {
            bridgeUID = parentBridge.getUID();
        } else if (!Objects.equal((Object)modelThing.getBridgeUID(), null) && !modelThing.getBridgeUID().isEmpty()) {
            ThingUID _thingUID;
            String _bridgeUID = modelThing.getBridgeUID();
            bridgeUID = _thingUID = new ThingUID(_bridgeUID);
        }
        boolean _isSupportedByThingHandlerFactory = this.isSupportedByThingHandlerFactory(thingTypeUID, thingHandlerFactory);
        boolean bl2 = _not = !_isSupportedByThingHandlerFactory;
        if (_not) {
            return;
        }
        logger.trace("Creating thing for type '{}' with UID '{}.", (Object)thingTypeUID, (Object)thingUID);
        Configuration configuration = this.createConfiguration(modelThing);
        ThingUID uid = thingUID;
        Functions.Function1 _function = it -> it.getUID().equals((Object)uid);
        boolean _exists = IterableExtensions.exists(thingList, (Functions.Function1)_function);
        if (_exists) {
            logger.debug("Thing already exists {}", (Object)uid.toString());
            return;
        }
        ThingType thingType = this.getThingType(thingTypeUID);
        String _xifexpression = null;
        String _label = modelThing.getLabel();
        boolean bl3 = _notEquals_1 = !Objects.equal((Object)_label, null);
        if (_notEquals_1) {
            _xifexpression = modelThing.getLabel();
        } else {
            String _label_1 = null;
            if (thingType != null) {
                _label_1 = thingType.getLabel();
            }
            _xifexpression = _label_1;
        }
        String label = _xifexpression;
        String location = modelThing.getLocation();
        Thing thingFromHandler = this.getThingFromThingHandlerFactories(thingTypeUID, label, configuration, thingUID, bridgeUID, thingHandlerFactory);
        Object _xifexpression_1 = null;
        _xifexpression_1 = modelThing instanceof ModelBridge ? BridgeBuilder.create((ThingTypeUID)thingTypeUID, (ThingUID)thingUID) : ThingBuilder.create((ThingTypeUID)thingTypeUID, (ThingUID)thingUID);
        BridgeBuilder thingBuilder = _xifexpression_1;
        thingBuilder.withConfiguration(configuration);
        thingBuilder.withBridge(bridgeUID);
        thingBuilder.withLabel(label);
        thingBuilder.withLocation(location);
        EList<ModelChannel> _channels = modelThing.getChannels();
        List _elvis = null;
        List _channelDefinitions = null;
        if (thingType != null) {
            _channelDefinitions = thingType.getChannelDefinitions();
        }
        if (_channelDefinitions != null) {
            _elvis = _channelDefinitions;
        } else {
            ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new ChannelDefinition[0]);
            _elvis = _newArrayList;
        }
        List<Channel> channels = this.createChannels(thingTypeUID, thingUID, (List<ModelChannel>)_channels, _elvis);
        thingBuilder.withChannels(channels);
        Thing thing = thingBuilder.build();
        boolean bl4 = _notEquals_2 = !Objects.equal((Object)thingFromHandler, null);
        if (_notEquals_2) {
            this.merge(thingFromHandler, thing);
        }
        Thing _elvis_1 = null;
        _elvis_1 = thingFromHandler != null ? thingFromHandler : thing;
        thingList.add(_elvis_1);
        if (modelThing instanceof ModelBridge) {
            Thing _elvis_2 = null;
            _elvis_2 = thingFromHandler != null ? thingFromHandler : thing;
            Bridge bridge = (Bridge)_elvis_2;
            Consumer<ModelThing> _function_1 = it -> this.createThing((ModelThing)it, bridge, thingList, thingHandlerFactory);
            ((ModelBridge)modelThing).getThings().forEach(_function_1);
        }
    }

    private boolean isSupportedByThingHandlerFactory(ThingTypeUID thingTypeUID, ThingHandlerFactory specific) {
        if (specific != null) {
            return specific.supportsThingType(thingTypeUID);
        }
        for (ThingHandlerFactory thingHandlerFactory : this.thingHandlerFactories) {
            boolean _supportsThingType = thingHandlerFactory.supportsThingType(thingTypeUID);
            if (!_supportsThingType) continue;
            return true;
        }
        return false;
    }

    private Thing getThingFromThingHandlerFactories(ThingTypeUID thingTypeUID, String label, Configuration configuration, ThingUID thingUID, ThingUID bridgeUID, ThingHandlerFactory specific) {
        Object _xblockexpression = null;
        if (!Objects.equal((Object)specific, null) && specific.supportsThingType(thingTypeUID)) {
            logger.trace("Creating thing from specific ThingHandlerFactory {} for thingType {}", (Object)specific, (Object)thingTypeUID);
            return this.getThingFromThingHandlerFactory(thingTypeUID, label, configuration, thingUID, bridgeUID, specific);
        }
        for (ThingHandlerFactory thingHandlerFactory : this.thingHandlerFactories) {
            logger.trace("Searching thingHandlerFactory for thingType: {}", (Object)thingTypeUID);
            boolean _supportsThingType = thingHandlerFactory.supportsThingType(thingTypeUID);
            if (!_supportsThingType) continue;
            return this.getThingFromThingHandlerFactory(thingTypeUID, label, configuration, thingUID, bridgeUID, thingHandlerFactory);
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    private Thing getThingFromThingHandlerFactory(ThingTypeUID thingTypeUID, String label, Configuration configuration, ThingUID thingUID, ThingUID bridgeUID, ThingHandlerFactory thingHandlerFactory) {
        Thing thing = thingHandlerFactory.createThing(thingTypeUID, configuration, thingUID, bridgeUID);
        boolean _equals = Objects.equal((Object)thing, null);
        if (_equals) {
            logger.debug("ThingHandlerFactory '{}' claimed it can handle '{}' type but actually did not. Queued for later refresh.", (Object)thingHandlerFactory.getClass().getSimpleName(), (Object)thingTypeUID.getAsString());
            QueueContent _queueContent = new QueueContent(thingTypeUID, label, configuration, thingUID, bridgeUID, thingHandlerFactory);
            this.queue.add(_queueContent);
            if (Objects.equal((Object)this.lazyRetryThread, null) || !this.lazyRetryThread.isAlive()) {
                Thread _thread;
                this.lazyRetryThread = _thread = new Thread(this.lazyRetryRunnable);
                this.lazyRetryThread.start();
            }
        } else {
            thing.setLabel(label);
        }
        return thing;
    }

    protected void _merge(Thing targetThing, Thing sourceThing) {
        targetThing.setBridgeUID(sourceThing.getBridgeUID());
        this.merge(targetThing.getConfiguration(), sourceThing.getConfiguration());
        this.merge(targetThing, sourceThing.getChannels());
        targetThing.setLocation(sourceThing.getLocation());
        targetThing.setLabel(sourceThing.getLabel());
    }

    protected void _merge(Configuration target, Configuration source) {
        Consumer<String> _function = it -> target.put(it, source.get(it));
        source.keySet().forEach(_function);
    }

    protected void _merge(Thing targetThing, List<Channel> source) {
        ArrayList channelsToAdd = CollectionLiterals.newArrayList((Object[])new Channel[0]);
        Consumer<Channel> _function = sourceChannel -> {
            Functions.Function1 _function_1 = it -> it.getUID().equals((Object)sourceChannel.getUID());
            Iterable targetChannels = IterableExtensions.filter((Iterable)targetThing.getChannels(), (Functions.Function1)_function_1);
            Consumer<Channel> _function_2 = it -> this.merge(it, sourceChannel);
            targetChannels.forEach(_function_2);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)targetChannels);
            if (_isEmpty) {
                channelsToAdd.add(sourceChannel);
            }
        };
        source.forEach(_function);
        ThingHelper.addChannelsToThing((Thing)targetThing, (Collection)channelsToAdd);
    }

    protected void _merge(Channel target, Channel source) {
        this.merge(target.getConfiguration(), source.getConfiguration());
    }

    private List<String> getParentPath(ThingUID bridgeUID) {
        List bridgeIds = bridgeUID.getBridgeIds();
        bridgeIds.add(bridgeUID.getId());
        return bridgeIds;
    }

    private List<Channel> createChannels(ThingTypeUID thingTypeUID, ThingUID thingUID, List<ModelChannel> modelChannels, List<ChannelDefinition> channelDefinitions) {
        ArrayList _xblockexpression = null;
        HashSet addedChannelIds = CollectionLiterals.newHashSet((Object[])new String[0]);
        ArrayList channels = CollectionLiterals.newArrayList((Object[])new Channel[0]);
        Consumer<ModelChannel> _function = it -> {
            boolean _add = addedChannelIds.add(it.getId());
            if (_add) {
                boolean _notEquals;
                ChannelKind parsedKind = ChannelKind.STATE;
                ChannelTypeUID channelTypeUID = null;
                String itemType = null;
                String label = it.getLabel();
                Configuration configuration = this.createConfiguration((ModelPropertyContainer)it);
                String _channelType = it.getChannelType();
                boolean bl = _notEquals = !Objects.equal((Object)_channelType, null);
                if (_notEquals) {
                    boolean _notEquals_1;
                    String _channelType_1;
                    String _bindingId = thingUID.getBindingId();
                    ChannelTypeUID _channelTypeUID = new ChannelTypeUID(_bindingId, _channelType_1 = it.getChannelType());
                    channelTypeUID = _channelTypeUID;
                    ChannelType resolvedChannelType = TypeResolver.resolve((ChannelTypeUID)channelTypeUID);
                    boolean bl2 = _notEquals_1 = !Objects.equal((Object)resolvedChannelType, null);
                    if (_notEquals_1) {
                        itemType = resolvedChannelType.getItemType();
                        parsedKind = resolvedChannelType.getKind();
                        boolean _equals = Objects.equal((Object)label, null);
                        if (_equals) {
                            label = resolvedChannelType.getLabel();
                        }
                        this.applyDefaultConfiguration(configuration, resolvedChannelType);
                    } else {
                        logger.error("Channel type {} could not be resolved.", (Object)channelTypeUID.getAsString());
                    }
                } else {
                    itemType = it.getType();
                    String _xifexpression = null;
                    String _channelKind = it.getChannelKind();
                    boolean _equals_1 = Objects.equal((Object)_channelKind, null);
                    _xifexpression = _equals_1 ? "State" : it.getChannelKind();
                    String kind = _xifexpression;
                    parsedKind = ChannelKind.parse((String)kind);
                }
                String _id = it.getId();
                ChannelUID _channelUID = new ChannelUID(thingUID, _id);
                ChannelBuilder channel = ChannelBuilder.create((ChannelUID)_channelUID, (String)itemType).withKind(parsedKind).withConfiguration(configuration).withType(channelTypeUID).withLabel(label);
                Channel _build = channel.build();
                channels.add(_build);
            }
        };
        modelChannels.forEach(_function);
        Consumer<ChannelDefinition> _function_1 = it -> {
            boolean _add = addedChannelIds.add(it.getId());
            if (_add) {
                boolean _notEquals;
                ChannelType channelType = TypeResolver.resolve((ChannelTypeUID)it.getChannelTypeUID());
                boolean bl = _notEquals = !Objects.equal((Object)channelType, null);
                if (_notEquals) {
                    String _id = it.getId();
                    ChannelUID _channelUID = new ChannelUID(thingTypeUID, thingUID, _id);
                    Channel _build = ChannelBuilder.create((ChannelUID)_channelUID, (String)channelType.getItemType()).withType(it.getChannelTypeUID()).build();
                    channels.add(_build);
                } else {
                    logger.warn("Could not create channel '{}' for thing '{}', because channel type '{}' could not be found.", new Object[]{it.getId(), thingUID, it.getChannelTypeUID()});
                }
            }
        };
        channelDefinitions.forEach(_function_1);
        _xblockexpression = channels;
        return _xblockexpression;
    }

    private void applyDefaultConfiguration(Configuration configuration, ChannelType channelType) {
        if (!Objects.equal((Object)this.configDescriptionRegistry, null) && !Objects.equal((Object)configuration, null)) {
            boolean _notEquals;
            URI _configDescriptionURI = channelType.getConfigDescriptionURI();
            boolean bl = _notEquals = !Objects.equal((Object)_configDescriptionURI, null);
            if (_notEquals) {
                boolean _notEquals_1;
                ConfigDescription configDescription = this.configDescriptionRegistry.getConfigDescription(channelType.getConfigDescriptionURI());
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)configDescription, null);
                if (_notEquals_1) {
                    Functions.Function1 _function = it -> !Objects.equal((Object)it.getDefault(), null) && Objects.equal((Object)configuration.get(it.getName()), null);
                    Consumer<ConfigDescriptionParameter> _function_1 = it -> {
                        boolean _notEquals_2;
                        Object value = this.getDefaultValueAsCorrectType(it.getType(), it.getDefault());
                        boolean bl = _notEquals_2 = !Objects.equal((Object)value, null);
                        if (_notEquals_2) {
                            configuration.put(it.getName(), value);
                        }
                    };
                    IterableExtensions.filter((Iterable)configDescription.getParameters(), (Functions.Function1)_function).forEach(_function_1);
                }
            }
        }
    }

    private Object getDefaultValueAsCorrectType(ConfigDescriptionParameter.Type parameterType, String defaultValue) {
        try {
            if (parameterType != null) {
                switch (parameterType) {
                    case TEXT: {
                        return defaultValue;
                    }
                    case BOOLEAN: {
                        return Boolean.parseBoolean(defaultValue);
                    }
                    case INTEGER: {
                        return new BigDecimal(defaultValue);
                    }
                    case DECIMAL: {
                        return new BigDecimal(defaultValue);
                    }
                }
                return null;
            }
            return null;
        }
        catch (Throwable _t) {
            if (_t instanceof NumberFormatException) {
                NumberFormatException ex = (NumberFormatException)_t;
                logger.warn("Could not parse default value '{}' as type '{}': {}", new Object[]{defaultValue, parameterType, ex.getMessage(), ex});
                return null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private Configuration createConfiguration(ModelPropertyContainer propertyContainer) {
        Configuration _xblockexpression = null;
        Configuration configuration = new Configuration();
        Consumer<ModelProperty> _function = it -> configuration.put(it.getKey(), it.getValue());
        propertyContainer.getProperties().forEach(_function);
        _xblockexpression = configuration;
        return _xblockexpression;
    }

    private ThingType getThingType(ThingTypeUID thingTypeUID) {
        ThingType _thingType = null;
        if (this.thingTypeRegistry != null) {
            _thingType = this.thingTypeRegistry.getThingType(thingTypeUID, this.localeProvider.getLocale());
        }
        return _thingType;
    }

    protected void setModelRepository(ModelRepository modelRepository) {
        this.modelRepository = modelRepository;
        modelRepository.addModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
    }

    protected void unsetModelRepository(ModelRepository modelRepository) {
        modelRepository.removeModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
        this.modelRepository = null;
    }

    public void modelChanged(String modelName, EventType type) {
        boolean _endsWith = modelName.endsWith("things");
        if (_endsWith && type != null) {
            switch (type) {
                case ADDED: {
                    this.createThingsFromModel(modelName);
                    break;
                }
                case MODIFIED: {
                    boolean _notEquals;
                    ArrayList _newArrayList;
                    ArrayList _elvis = null;
                    ArrayList _get = this.thingsMap.get(modelName);
                    _elvis = _get != null ? _get : (_newArrayList = CollectionLiterals.newArrayList((Object[])new Thing[0]));
                    ArrayList oldThings = _elvis;
                    EObject _model = this.modelRepository.getModel(modelName);
                    ThingModel model = (ThingModel)_model;
                    boolean bl = _notEquals = !Objects.equal((Object)model, null);
                    if (!_notEquals) break;
                    Set<ThingUID> newThingUIDs = this.getAllThingUIDs(model);
                    Functions.Function1 _function = it -> {
                        boolean _contains = newThingUIDs.contains(it.getUID());
                        return !_contains;
                    };
                    Iterable removedThings = IterableExtensions.filter((Iterable)oldThings, (Functions.Function1)_function);
                    Consumer<Thing> _function_1 = it -> this.notifyListenersAboutRemovedElement(it);
                    removedThings.forEach(_function_1);
                    this.createThingsFromModel(modelName);
                    break;
                }
                case REMOVED: {
                    ArrayList _newArrayList_1;
                    ArrayList _elvis_1 = null;
                    ArrayList _remove = this.thingsMap.remove(modelName);
                    _elvis_1 = _remove != null ? _remove : (_newArrayList_1 = CollectionLiterals.newArrayList((Object[])new Thing[0]));
                    ArrayList things = _elvis_1;
                    Consumer<Thing> _function_2 = it -> this.notifyListenersAboutRemovedElement(it);
                    things.forEach(_function_2);
                    break;
                }
            }
        }
    }

    private Set<ThingUID> getAllThingUIDs(ThingModel model) {
        return this.getAllThingUIDs((List<ModelThing>)model.getThings(), null);
    }

    private Set<ThingUID> getAllThingUIDs(List<ModelThing> thingList, ThingUID parentUID) {
        HashSet<ThingUID> ret = new HashSet<ThingUID>();
        Consumer<ModelThing> _function = it -> {
            ThingUID thingUID2 = this.getThingUID((ModelThing)it, parentUID);
            ret.add(thingUID2);
            if (it instanceof ModelBridge) {
                ret.addAll(this.getAllThingUIDs((List<ModelThing>)((ModelBridge)it).getThings(), thingUID2));
            }
        };
        thingList.forEach(_function);
        return ret;
    }

    private ThingUID getThingUID(ModelThing modelThing, ThingUID parentUID) {
        if (!Objects.equal((Object)parentUID, null) && Objects.equal((Object)modelThing.getId(), null)) {
            String _bindingId = parentUID.getBindingId();
            String _thingTypeId = modelThing.getThingTypeId();
            ThingTypeUID thingTypeUID = new ThingTypeUID(_bindingId, _thingTypeId);
            String _thingId = modelThing.getThingId();
            List<String> _parentPath = this.getParentPath(parentUID);
            return new ThingUID(thingTypeUID, _thingId, (String[])Conversions.unwrapArray(_parentPath, String.class));
        }
        return this.constructThingUID(modelThing);
    }

    protected void setLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    protected void unsetLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = null;
    }

    protected void setThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = thingTypeRegistry;
    }

    protected void unsetThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = null;
    }

    protected void addThingHandlerFactory(ThingHandlerFactory thingHandlerFactory) {
        logger.debug("ThingHandlerFactory added {}", (Object)thingHandlerFactory);
        this.thingHandlerFactories.add(thingHandlerFactory);
        this.thingHandlerFactoryAdded(thingHandlerFactory);
    }

    protected void removeThingHandlerFactory(ThingHandlerFactory thingHandlerFactory) {
        this.thingHandlerFactories.remove(thingHandlerFactory);
        this.thingHandlerFactoryRemoved();
    }

    private Object thingHandlerFactoryRemoved() {
        return null;
    }

    private void thingHandlerFactoryAdded(ThingHandlerFactory thingHandlerFactory) {
        Consumer<String> _function = it -> this.createThingsFromModelForThingHandlerFactory((String)it, thingHandlerFactory);
        this.thingsMap.keySet().forEach(_function);
    }

    public void setReadyService(ReadyService readyService) {
        readyService.registerTracker((ReadyService.ReadyTracker)this, new ReadyMarkerFilter().withType(XML_THING_TYPE));
    }

    public void unsetReadyService(ReadyService readyService) {
        readyService.unregisterTracker((ReadyService.ReadyTracker)this);
    }

    public void onReadyMarkerAdded(ReadyMarker readyMarker) {
        String bsn = readyMarker.getIdentifier();
        this.loadedXmlThingTypes.add(bsn);
        this.handleXmlThingTypesLoaded(bsn);
    }

    private String getBundleName(ThingHandlerFactory thingHandlerFactory) {
        return FrameworkUtil.getBundle(thingHandlerFactory.getClass()).getSymbolicName();
    }

    private void handleXmlThingTypesLoaded(String bsn) {
        Functions.Function1 _function = it -> this.getBundleName((ThingHandlerFactory)it).equals(bsn);
        Consumer<ThingHandlerFactory> _function_1 = thingHandlerFactory -> this.thingHandlerFactoryAdded((ThingHandlerFactory)thingHandlerFactory);
        IterableExtensions.filter(this.thingHandlerFactories, (Functions.Function1)_function).forEach(_function_1);
    }

    public void onReadyMarkerRemoved(ReadyMarker readyMarker) {
        String bsn = readyMarker.getIdentifier();
        this.loadedXmlThingTypes.remove(bsn);
    }

    private void createThingsFromModelForThingHandlerFactory(String modelName, ThingHandlerFactory factory) {
        boolean _notEquals;
        boolean _not;
        boolean _contains = this.loadedXmlThingTypes.contains(this.getBundleName(factory));
        boolean bl = _not = !_contains;
        if (_not) {
            return;
        }
        Thing[] oldThings = (Thing[])((Thing[])Conversions.unwrapArray(this.thingsMap.get(modelName), Thing.class)).clone();
        ArrayList newThings = CollectionLiterals.newArrayList((Object[])new Thing[0]);
        boolean bl2 = _notEquals = !Objects.equal((Object)this.modelRepository, null);
        if (_notEquals) {
            boolean _notEquals_1;
            EObject _model = this.modelRepository.getModel(modelName);
            ThingModel model = (ThingModel)_model;
            boolean bl3 = _notEquals_1 = !Objects.equal((Object)model, null);
            if (_notEquals_1) {
                Consumer<ModelThing> _function = it -> this.createThing((ModelThing)it, null, newThings, factory);
                model.getThings().forEach(_function);
            }
        }
        Consumer<Thing> _function_1 = newThing -> {
            boolean _notEquals_2;
            Functions.Function1 _function_2 = it -> {
                ThingUID _uID = it.getUID();
                ThingUID _uID_1 = newThing.getUID();
                return Objects.equal((Object)_uID, (Object)_uID_1);
            };
            Thing oldThing = (Thing)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)oldThings)), (Functions.Function1)_function_2);
            boolean bl = _notEquals_2 = !Objects.equal((Object)oldThing, null);
            if (_notEquals_2) {
                logger.debug("Updating thing '{}' from model '{}'.", (Object)newThing.getUID(), (Object)modelName);
                this.notifyListenersAboutUpdatedElement(oldThing, newThing);
            } else {
                logger.debug("Adding thing '{}' from model '{}'.", (Object)newThing.getUID(), (Object)modelName);
                this.thingsMap.get(modelName).add((Thing)newThing);
                this.notifyListenersAboutAddedElement(newThing);
            }
        };
        newThings.forEach(_function_1);
    }

    protected void setConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescriptionRegistry = configDescriptionRegistry;
    }

    protected void unsetConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescriptionRegistry = null;
    }

    public void merge(Object targetThing, Object source) {
        if (targetThing instanceof Thing && source instanceof List) {
            this._merge((Thing)targetThing, (List)source);
            return;
        }
        if (targetThing instanceof Thing && source instanceof Thing) {
            this._merge((Thing)targetThing, (Thing)source);
            return;
        }
        if (targetThing instanceof Configuration && source instanceof Configuration) {
            this._merge((Configuration)targetThing, (Configuration)source);
            return;
        }
        if (targetThing instanceof Channel && source instanceof Channel) {
            this._merge((Channel)targetThing, (Channel)source);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(targetThing, source).toString());
    }

    @Data
    private static final class QueueContent {
        private final ThingTypeUID thingTypeUID;
        private final String label;
        private final Configuration configuration;
        private final ThingUID thingUID;
        private final ThingUID bridgeUID;
        private final ThingHandlerFactory thingHandlerFactory;

        public QueueContent(ThingTypeUID thingTypeUID, String label, Configuration configuration, ThingUID thingUID, ThingUID bridgeUID, ThingHandlerFactory thingHandlerFactory) {
            this.thingTypeUID = thingTypeUID;
            this.label = label;
            this.configuration = configuration;
            this.thingUID = thingUID;
            this.bridgeUID = bridgeUID;
            this.thingHandlerFactory = thingHandlerFactory;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.thingTypeUID == null ? 0 : this.thingTypeUID.hashCode());
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            result = 31 * result + (this.configuration == null ? 0 : this.configuration.hashCode());
            result = 31 * result + (this.thingUID == null ? 0 : this.thingUID.hashCode());
            result = 31 * result + (this.bridgeUID == null ? 0 : this.bridgeUID.hashCode());
            result = 31 * result + (this.thingHandlerFactory == null ? 0 : this.thingHandlerFactory.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QueueContent other = (QueueContent)obj;
            if (this.thingTypeUID == null ? other.thingTypeUID != null : !this.thingTypeUID.equals((Object)other.thingTypeUID)) {
                return false;
            }
            if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
                return false;
            }
            if (this.configuration == null ? other.configuration != null : !this.configuration.equals((Object)other.configuration)) {
                return false;
            }
            if (this.thingUID == null ? other.thingUID != null : !this.thingUID.equals((Object)other.thingUID)) {
                return false;
            }
            if (this.bridgeUID == null ? other.bridgeUID != null : !this.bridgeUID.equals((Object)other.bridgeUID)) {
                return false;
            }
            return !(this.thingHandlerFactory == null ? other.thingHandlerFactory != null : !this.thingHandlerFactory.equals(other.thingHandlerFactory));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("thingTypeUID", (Object)this.thingTypeUID);
            b.add("label", (Object)this.label);
            b.add("configuration", (Object)this.configuration);
            b.add("thingUID", (Object)this.thingUID);
            b.add("bridgeUID", (Object)this.bridgeUID);
            b.add("thingHandlerFactory", (Object)this.thingHandlerFactory);
            return b.toString();
        }

        @Pure
        public ThingTypeUID getThingTypeUID() {
            return this.thingTypeUID;
        }

        @Pure
        public String getLabel() {
            return this.label;
        }

        @Pure
        public Configuration getConfiguration() {
            return this.configuration;
        }

        @Pure
        public ThingUID getThingUID() {
            return this.thingUID;
        }

        @Pure
        public ThingUID getBridgeUID() {
            return this.bridgeUID;
        }

        @Pure
        public ThingHandlerFactory getThingHandlerFactory() {
            return this.thingHandlerFactory;
        }
    }
}

