/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.script;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.eclipse.smarthome.model.script.engine.ScriptEngine;
import org.eclipse.smarthome.model.script.engine.action.ActionService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptServiceUtil {
    private final Logger logger = LoggerFactory.getLogger(ScriptServiceUtil.class);
    private static ScriptServiceUtil instance;
    private ItemRegistry itemRegistry;
    private ThingRegistry thingRegistry;
    private EventPublisher eventPublisher;
    private ModelRepository modelRepository;
    private final AtomicReference<ScriptEngine> scriptEngine = new AtomicReference();
    public List<ActionService> actionServices = new CopyOnWriteArrayList<ActionService>();

    public void activate(BundleContext bc) {
        if (instance != null) {
            throw new IllegalStateException("ScriptServiceUtil should only be activated once!");
        }
        instance = this;
        this.logger.debug("ScriptServiceUtil started");
    }

    public void deactivate() {
        this.logger.debug("ScriptServiceUtil stopped");
        instance = null;
    }

    private static ScriptServiceUtil getInstance() {
        if (instance == null) {
            Logger logger = LoggerFactory.getLogger(ScriptServiceUtil.class);
            Bundle bundle = FrameworkUtil.getBundle(ScriptServiceUtil.class);
            BundleContext context = bundle.getBundleContext();
            if (context != null) {
                logger.debug("ScriptServiceUtil is not initialized!\n  ThingRegistry: {}\n  ItemRegistry: {}\n  EventPublisher: {}\n  ModelRepository: {}", new Object[]{context.getServiceReference("org.eclipse.smarthome.core.thing.ThingRegistry"), context.getServiceReference("org.eclipse.smarthome.core.items.ItemRegistry"), context.getServiceReference("org.eclipse.smarthome.core.events.EventPublisher"), context.getServiceReference("org.eclipse.smarthome.model.core.ModelRepository")});
                logger.debug("Bundle Versions:\n  o.e.sh.model.rule.runtime: {}\n  o.e.sh.model.core: {}", (Object)ScriptServiceUtil.getVersion(context, "org.eclipse.smarthome.model.rule.runtime"), (Object)ScriptServiceUtil.getVersion(context, "org.eclipse.smarthome.model.core"));
            } else {
                logger.debug("Bundle {} is not started", (Object)bundle.getSymbolicName());
            }
            throw new IllegalStateException("ScriptServiceUtil not initialized yet!");
        }
        return instance;
    }

    private static String getVersion(BundleContext context, String bsn) {
        Bundle[] bundleArray = context.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundle.getSymbolicName().equals(bsn)) {
                return bundle.getVersion().toString();
            }
            ++n2;
        }
        return null;
    }

    public static ItemRegistry getItemRegistry() {
        return ScriptServiceUtil.getInstance().itemRegistry;
    }

    public ItemRegistry getItemRegistryInstance() {
        return this.itemRegistry;
    }

    public ThingRegistry getThingRegistryInstance() {
        return this.thingRegistry;
    }

    public static EventPublisher getEventPublisher() {
        return ScriptServiceUtil.getInstance().eventPublisher;
    }

    public static ModelRepository getModelRepository() {
        return ScriptServiceUtil.getInstance().modelRepository;
    }

    public ModelRepository getModelRepositoryInstance() {
        return this.modelRepository;
    }

    public static ScriptEngine getScriptEngine() {
        return ScriptServiceUtil.getInstance().scriptEngine.get();
    }

    public static List<ActionService> getActionServices() {
        return ScriptServiceUtil.getInstance().actionServices;
    }

    public List<ActionService> getActionServiceInstances() {
        return this.actionServices;
    }

    public void addActionService(ActionService actionService) {
        this.actionServices.add(actionService);
    }

    public void removeActionService(ActionService actionService) {
        this.actionServices.remove(actionService);
    }

    public void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    public void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    public void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    public void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = null;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    public void setModelRepository(ModelRepository modelRepository) {
        this.modelRepository = modelRepository;
    }

    public void unsetModelRepository(ModelRepository modelRepository) {
        this.modelRepository = null;
    }

    public void setScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine.set(scriptEngine);
    }

    public void unsetScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine.compareAndSet(scriptEngine, null);
    }
}

