/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.monitor.internal;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventFilter;
import org.eclipse.smarthome.core.events.EventSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventLogger
implements EventSubscriber {
    private final Map<String, Logger> eventLoggers = Maps.newHashMap();
    private final Set<String> subscribedEventTypes = ImmutableSet.of((Object)"ALL");

    public Set<String> getSubscribedEventTypes() {
        return this.subscribedEventTypes;
    }

    public EventFilter getEventFilter() {
        return null;
    }

    public void receive(Event event) {
        Logger logger = this.getLogger(event.getType());
        logger.trace("Received event of type '{}' under the topic '{}' with payload: '{}'", new Object[]{event.getType(), event.getTopic(), event.getPayload()});
        logger.info("{}", (Object)event);
    }

    private Logger getLogger(String eventType) {
        String loggerName = "smarthome.event." + eventType;
        Logger logger = this.eventLoggers.get(loggerName);
        if (logger == null) {
            logger = LoggerFactory.getLogger((String)loggerName);
            this.eventLoggers.put(loggerName, logger);
        }
        return logger;
    }
}

