/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.net;

import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServiceUtil {
    private HttpServiceUtil() {
    }

    public static int getHttpServicePort(BundleContext bc) {
        return HttpServiceUtil.getHttpServicePortProperty(bc, "org.osgi.service.http.port");
    }

    public static int getHttpServicePortSecure(BundleContext bc) {
        return HttpServiceUtil.getHttpServicePortProperty(bc, "org.osgi.service.http.port.secure");
    }

    private static int getHttpServicePortProperty(BundleContext bc, String propertyName) {
        Object value;
        ServiceReference[] refs;
        int port = -1;
        try {
            refs = bc.getAllServiceReferences("org.osgi.service.http.HttpService", null);
        }
        catch (InvalidSyntaxException ex) {
            Logger logger = LoggerFactory.getLogger(HttpServiceUtil.class);
            logger.warn("This error should only be thrown if a filter could not be parsed. We don't use a filter...");
            return -1;
        }
        int candidate = Integer.MIN_VALUE;
        ServiceReference[] serviceReferenceArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            block14: {
                ServiceReference ref = serviceReferenceArray[n2];
                value = ref.getProperty(propertyName);
                if (value != null) {
                    int servicePort;
                    try {
                        servicePort = Integer.parseInt(value.toString());
                    }
                    catch (NumberFormatException ex) {
                        break block14;
                    }
                    value = ref.getProperty("service.ranking");
                    int serviceRanking = value == null || !(value instanceof Integer) ? 0 : (Integer)value;
                    if (serviceRanking >= candidate) {
                        candidate = serviceRanking;
                        port = servicePort;
                    }
                }
            }
            ++n2;
        }
        if (port > 0) {
            return port;
        }
        value = bc.getProperty(propertyName);
        if (value != null) {
            if (value instanceof String) {
                try {
                    return Integer.parseInt(value.toString());
                }
                catch (NumberFormatException numberFormatException) {
                }
            } else if (value instanceof Integer) {
                return (Integer)value;
            }
        }
        return -1;
    }
}

