/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library.types;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.PrimitiveType;
import org.eclipse.smarthome.core.types.State;

public class DateTimeType
implements PrimitiveType,
State,
Command {
    public static final String DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String DATE_PATTERN_WITH_TZ = "yyyy-MM-dd'T'HH:mm:ssz";
    public static final String DATE_PATTERN_WITH_TZ_AND_MS = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String DATE_PATTERN_WITH_TZ_AND_MS_GENERAL = "yyyy-MM-dd'T'HH:mm:ss.SSSz";
    public static final String DATE_PATTERN_WITH_TZ_AND_MS_ISO = "yyyy-MM-dd'T'HH:mm:ss.SSSX";
    private ZonedDateTime zonedDateTime;
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
    private final DateTimeFormatter formatterTz = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssz");
    private final DateTimeFormatter formatterTzMs = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSz");
    private final DateTimeFormatter formatterTzMsRFC = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private final DateTimeFormatter formatterTzMsIso = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX");

    @Deprecated
    public DateTimeType(Calendar calendar) {
        this.zonedDateTime = ZonedDateTime.ofInstant(calendar.toInstant(), TimeZone.getDefault().toZoneId()).withFixedOffsetZone();
    }

    public DateTimeType() {
        this(ZonedDateTime.now());
    }

    public DateTimeType(ZonedDateTime zoned) {
        this.zonedDateTime = ZonedDateTime.from(zoned).withFixedOffsetZone();
    }

    public DateTimeType(String zonedValue) {
        ZonedDateTime date = null;
        try {
            try {
                date = ZonedDateTime.parse(zonedValue, this.formatterTzMsRFC);
            }
            catch (DateTimeParseException tzMsRfcException) {
                try {
                    date = ZonedDateTime.parse(zonedValue, this.formatterTzMsIso);
                }
                catch (DateTimeParseException tzMsException) {
                    try {
                        date = ZonedDateTime.parse(zonedValue, this.formatterTz);
                    }
                    catch (DateTimeParseException tzException) {
                        try {
                            date = ZonedDateTime.parse(zonedValue, this.formatterTzMs);
                        }
                        catch (DateTimeParseException regularFormatException) {
                            LocalDateTime localDateTime = LocalDateTime.parse(zonedValue, this.formatter);
                            date = ZonedDateTime.of(localDateTime, ZoneId.systemDefault());
                        }
                    }
                }
            }
        }
        catch (DateTimeParseException invalidFormatException) {
            throw new IllegalArgumentException(String.valueOf(zonedValue) + " is not in a valid format.", invalidFormatException);
        }
        if (date != null) {
            this.zonedDateTime = date;
        }
    }

    @Deprecated
    public Calendar getCalendar() {
        return GregorianCalendar.from(this.zonedDateTime);
    }

    public ZonedDateTime getZonedDateTime() {
        return this.zonedDateTime;
    }

    public static DateTimeType valueOf(String value) {
        return new DateTimeType(value);
    }

    @Override
    public String format(String pattern) {
        try {
            return String.format(pattern, this.zonedDateTime);
        }
        catch (NullPointerException npe) {
            return DateTimeFormatter.ofPattern(DATE_PATTERN).format(this.zonedDateTime);
        }
    }

    public String format(Locale locale, String pattern) {
        return String.format(locale, pattern, this.zonedDateTime);
    }

    public String toString() {
        return this.toFullString();
    }

    @Override
    public String toFullString() {
        return this.zonedDateTime.format(this.formatterTzMsRFC);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getZonedDateTime() == null ? 0 : this.getZonedDateTime().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateTimeType other = (DateTimeType)obj;
        return !(this.zonedDateTime == null ? other.zonedDateTime != null : this.zonedDateTime.compareTo(other.zonedDateTime) != 0);
    }
}

