/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library.items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.library.types.StopMoveType;
import org.eclipse.smarthome.core.library.types.UpDownType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;

public class RollershutterItem
extends GenericItem {
    private static List<Class<? extends State>> acceptedDataTypes = new ArrayList<Class<? extends State>>();
    private static List<Class<? extends Command>> acceptedCommandTypes = new ArrayList<Class<? extends Command>>();

    static {
        acceptedDataTypes.add(PercentType.class);
        acceptedDataTypes.add(UpDownType.class);
        acceptedDataTypes.add(UnDefType.class);
        acceptedCommandTypes.add(UpDownType.class);
        acceptedCommandTypes.add(StopMoveType.class);
        acceptedCommandTypes.add(PercentType.class);
        acceptedCommandTypes.add(RefreshType.class);
    }

    public RollershutterItem(@NonNull String name) {
        super("Rollershutter", name);
    }

    @Override
    public List<Class<? extends State>> getAcceptedDataTypes() {
        return Collections.unmodifiableList(acceptedDataTypes);
    }

    @Override
    public List<Class<? extends Command>> getAcceptedCommandTypes() {
        return Collections.unmodifiableList(acceptedCommandTypes);
    }

    public void send(UpDownType command) {
        this.internalSend(command);
    }

    public void send(StopMoveType command) {
        this.internalSend(command);
    }

    public void send(PercentType command) {
        this.internalSend(command);
    }

    @Override
    public void setState(State state) {
        if (this.isAcceptedState(acceptedDataTypes, state)) {
            State convertedState = state.as(PercentType.class);
            if (convertedState != null) {
                this.applyState(convertedState);
            } else {
                this.applyState(state);
            }
        } else {
            this.logSetTypeError(state);
        }
    }
}

