/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.items.dto;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.smarthome.core.items.ActiveItem;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.GroupFunction;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemFactory;
import org.eclipse.smarthome.core.items.dto.GroupFunctionDTO;
import org.eclipse.smarthome.core.items.dto.GroupItemDTO;
import org.eclipse.smarthome.core.items.dto.ItemDTO;
import org.eclipse.smarthome.core.library.types.ArithmeticGroupFunction;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.TypeParser;
import org.slf4j.LoggerFactory;

public class ItemDTOMapper {
    public static ActiveItem map(ItemDTO itemDTO, Set<ItemFactory> itemFactories) {
        Preconditions.checkArgument((itemDTO != null ? 1 : 0) != 0, (Object)"The argument 'itemDTO' must no be null.");
        Preconditions.checkArgument((itemFactories != null ? 1 : 0) != 0, (Object)"The argument 'itemFactories' must no be null.");
        GenericItem newItem = null;
        if (itemDTO.type != null) {
            if (itemDTO instanceof GroupItemDTO && itemDTO.type.equals("Group")) {
                GroupItemDTO groupItemDTO = (GroupItemDTO)itemDTO;
                GenericItem baseItem = null;
                if (!Strings.isNullOrEmpty((String)groupItemDTO.groupType)) {
                    baseItem = ItemDTOMapper.createItem(groupItemDTO.groupType, itemDTO.name, itemFactories);
                }
                GroupFunction function = new GroupFunction.Equality();
                if (groupItemDTO.function != null) {
                    function = ItemDTOMapper.mapFunction(baseItem, groupItemDTO.function);
                }
                newItem = new GroupItem(itemDTO.name, baseItem, function);
            } else {
                String itemType = itemDTO.type;
                newItem = ItemDTOMapper.createItem(itemType, itemDTO.name, itemFactories);
            }
            if (newItem != null) {
                if (itemDTO.label != null) {
                    newItem.setLabel(itemDTO.label);
                }
                if (itemDTO.category != null) {
                    newItem.setCategory(itemDTO.category);
                }
                if (itemDTO.groupNames != null) {
                    newItem.addGroupNames(itemDTO.groupNames);
                }
                if (itemDTO.tags != null) {
                    newItem.addTags(itemDTO.tags);
                }
            }
        }
        return newItem;
    }

    public static GroupFunction mapFunction(Item baseItem, GroupFunctionDTO function) {
        List<Object> args = new ArrayList();
        GroupFunction groupFunction = null;
        switch (function.name.toUpperCase()) {
            case "AND": {
                args = ItemDTOMapper.parseStates(baseItem, function.params);
                if (args.size() == 2) {
                    groupFunction = new ArithmeticGroupFunction.And((State)args.get(0), (State)args.get(1));
                    break;
                }
                LoggerFactory.getLogger(ItemDTOMapper.class).error("Group function 'AND' requires two arguments. Using Equality instead.");
                break;
            }
            case "OR": {
                args = ItemDTOMapper.parseStates(baseItem, function.params);
                if (args.size() == 2) {
                    groupFunction = new ArithmeticGroupFunction.Or((State)args.get(0), (State)args.get(1));
                    break;
                }
                LoggerFactory.getLogger(ItemDTOMapper.class).error("Group function 'OR' requires two arguments. Using Equality instead.");
                break;
            }
            case "NAND": {
                args = ItemDTOMapper.parseStates(baseItem, function.params);
                if (args.size() == 2) {
                    groupFunction = new ArithmeticGroupFunction.NAnd((State)args.get(0), (State)args.get(1));
                    break;
                }
                LoggerFactory.getLogger(ItemDTOMapper.class).error("Group function 'NOT AND' requires two arguments. Using Equality instead.");
                break;
            }
            case "NOR": {
                args = ItemDTOMapper.parseStates(baseItem, function.params);
                if (args.size() == 2) {
                    groupFunction = new ArithmeticGroupFunction.NOr((State)args.get(0), (State)args.get(1));
                    break;
                }
                LoggerFactory.getLogger(ItemDTOMapper.class).error("Group function 'NOT OR' requires two arguments. Using Equality instead.");
                break;
            }
            case "COUNT": {
                if (function.params != null && function.params.length == 1) {
                    StringType countParam = new StringType(function.params[0]);
                    groupFunction = new ArithmeticGroupFunction.Count(countParam);
                    break;
                }
                LoggerFactory.getLogger(ItemDTOMapper.class).error("Group function 'COUNT' requires one argument. Using Equality instead.");
                break;
            }
            case "AVG": {
                groupFunction = new ArithmeticGroupFunction.Avg();
                break;
            }
            case "SUM": {
                groupFunction = new ArithmeticGroupFunction.Sum();
                break;
            }
            case "MIN": {
                groupFunction = new ArithmeticGroupFunction.Min();
                break;
            }
            case "MAX": {
                groupFunction = new ArithmeticGroupFunction.Max();
                break;
            }
            case "EQUAL": {
                groupFunction = new GroupFunction.Equality();
                break;
            }
            default: {
                LoggerFactory.getLogger(ItemDTOMapper.class).error("Unknown group function '{}'. Using Equality instead.", (Object)function.name);
            }
        }
        if (groupFunction == null) {
            groupFunction = new GroupFunction.Equality();
        }
        return groupFunction;
    }

    private static List<State> parseStates(Item baseItem, String[] params) {
        ArrayList<State> states = new ArrayList<State>();
        if (params == null) {
            return states;
        }
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            State state = TypeParser.parseState(baseItem.getAcceptedDataTypes(), param);
            if (state == null) {
                LoggerFactory.getLogger(ItemDTOMapper.class).warn("State '{}' is not valid for a group item with base type '{}'", new Object[]{param, baseItem.getType()});
                states.clear();
                break;
            }
            states.add(state);
            ++n2;
        }
        return states;
    }

    public static ItemDTO map(Item item) {
        ItemDTO itemDTO = item instanceof GroupItem ? new GroupItemDTO() : new ItemDTO();
        ItemDTOMapper.fillProperties(itemDTO, item);
        return itemDTO;
    }

    private static void fillProperties(ItemDTO itemDTO, Item item) {
        if (item instanceof GroupItem) {
            GroupItem groupItem = (GroupItem)item;
            GroupItemDTO groupItemDTO = (GroupItemDTO)itemDTO;
            if (groupItem.getBaseItem() != null) {
                groupItemDTO.groupType = groupItem.getBaseItem().getType();
                groupItemDTO.function = ItemDTOMapper.mapFunction(groupItem.getFunction());
            }
        }
        itemDTO.name = item.getName();
        itemDTO.type = item.getType();
        itemDTO.label = item.getLabel();
        itemDTO.tags = item.getTags();
        itemDTO.category = item.getCategory();
        itemDTO.groupNames = item.getGroupNames();
    }

    public static GroupFunctionDTO mapFunction(GroupFunction function) {
        GroupFunctionDTO dto = new GroupFunctionDTO();
        dto.name = function.getClass().getSimpleName().toUpperCase();
        ArrayList<String> params = new ArrayList<String>();
        State[] stateArray = function.getParameters();
        int n = stateArray.length;
        int n2 = 0;
        while (n2 < n) {
            State param = stateArray[n2];
            params.add(param.toString());
            ++n2;
        }
        if (!params.isEmpty()) {
            dto.params = params.toArray(new String[params.size()]);
        }
        return dto;
    }

    private static GenericItem createItem(String itemType, String itemname, Set<ItemFactory> itemFactories) {
        GenericItem newItem = null;
        for (ItemFactory itemFactory : itemFactories) {
            newItem = itemFactory.createItem(itemType, itemname);
            if (newItem != null) break;
        }
        return newItem;
    }
}

