/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.items;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.core.common.registry.AbstractManagedProvider;
import org.eclipse.smarthome.core.items.ActiveItem;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.GroupFunction;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemFactory;
import org.eclipse.smarthome.core.items.ItemProvider;
import org.eclipse.smarthome.core.items.dto.GroupFunctionDTO;
import org.eclipse.smarthome.core.items.dto.ItemDTOMapper;
import org.eclipse.smarthome.core.storage.StorageService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ItemProvider.class, ManagedItemProvider.class})
public class ManagedItemProvider
extends AbstractManagedProvider<Item, String, PersistedItem>
implements ItemProvider {
    private static final @NonNull String ITEM_TYPE_GROUP = "Group";
    private final Logger logger = LoggerFactory.getLogger(ManagedItemProvider.class);
    private final Collection<ItemFactory> itemFactories = new CopyOnWriteArrayList<ItemFactory>();
    private final Map<String, PersistedItem> failedToCreate = new ConcurrentHashMap<String, PersistedItem>();

    public Item remove(String itemName, boolean recursive) {
        Item item = (Item)this.get(itemName);
        if (recursive && item instanceof GroupItem) {
            for (String member : this.getMemberNamesRecursively((GroupItem)item, this.getAll())) {
                this.remove(member);
            }
        }
        if (item != null) {
            this.remove(item.getName());
            return item;
        }
        return null;
    }

    private List<@NonNull String> getMemberNamesRecursively(GroupItem groupItem, Collection<Item> allItems) {
        ArrayList<@NonNull String> memberNames = new ArrayList<String>();
        for (Item item : allItems) {
            if (!item.getGroupNames().contains(groupItem.getName())) continue;
            memberNames.add(item.getName());
            if (!(item instanceof GroupItem)) continue;
            memberNames.addAll(this.getMemberNamesRecursively((GroupItem)item, allItems));
        }
        return memberNames;
    }

    private GenericItem createItem(@NonNull String itemType, @NonNull String itemName) {
        for (ItemFactory factory : this.itemFactories) {
            GenericItem item = factory.createItem(itemType, itemName);
            if (item == null) continue;
            return item;
        }
        this.logger.debug("Couldn't find ItemFactory for item '{}' of type '{}'", (Object)itemName, (Object)itemType);
        return null;
    }

    private @NonNull String toItemFactoryName(Item item) {
        return item.getType();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addItemFactory(ItemFactory itemFactory) {
        this.itemFactories.add(itemFactory);
        if (this.failedToCreate.size() > 0) {
            Iterator<Map.Entry<String, PersistedItem>> iterator = this.failedToCreate.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, PersistedItem> entry = iterator.next();
                String itemName = entry.getKey();
                PersistedItem persistedItem = entry.getValue();
                GenericItem item = itemFactory.createItem(persistedItem.itemType, itemName);
                if (item != null) {
                    iterator.remove();
                    this.configureItem(persistedItem, item);
                    this.notifyListenersAboutAddedElement(item);
                    continue;
                }
                this.logger.debug("The added item factory '{}' still could not instantiate item '{}'.", (Object)itemFactory, (Object)itemName);
            }
            if (this.failedToCreate.isEmpty()) {
                this.logger.info("Finished loading the items which could not have been created before.");
            }
        }
    }

    @Override
    protected String getStorageName() {
        return Item.class.getName();
    }

    @Override
    protected String keyToString(String key) {
        return key;
    }

    protected void removeItemFactory(ItemFactory itemFactory) {
        this.itemFactories.remove(itemFactory);
    }

    @Override
    protected Item toElement(String itemName, PersistedItem persistedItem) {
        GenericItem item = null;
        if (persistedItem.itemType.equals(ITEM_TYPE_GROUP)) {
            if (persistedItem.baseItemType != null) {
                GenericItem baseItem = this.createItem(persistedItem.baseItemType, itemName);
                if (persistedItem.functionName != null) {
                    GroupFunction function = this.getGroupFunction(persistedItem, baseItem);
                    item = new GroupItem(itemName, baseItem, function);
                } else {
                    item = new GroupItem(itemName, baseItem, new GroupFunction.Equality());
                }
            } else {
                item = new GroupItem(itemName);
            }
        } else {
            item = this.createItem(persistedItem.itemType, itemName);
        }
        this.configureItem(persistedItem, item);
        if (item == null) {
            this.failedToCreate.put(itemName, persistedItem);
            this.logger.debug("Couldn't restore item '{}' of type '{}' ~\u00a0there is no appropriate ItemFactory available.", (Object)itemName, (Object)persistedItem.itemType);
        }
        return item;
    }

    private GroupFunction getGroupFunction(PersistedItem persistedItem, GenericItem baseItem) {
        GroupFunctionDTO functionDTO = new GroupFunctionDTO();
        functionDTO.name = persistedItem.functionName;
        if (persistedItem.functionParams != null) {
            functionDTO.params = persistedItem.functionParams.toArray(new String[persistedItem.functionParams.size()]);
        }
        return ItemDTOMapper.mapFunction(baseItem, functionDTO);
    }

    private void configureItem(PersistedItem persistedItem, ActiveItem item) {
        if (item != null) {
            Set<String> tags;
            List<String> groupNames = persistedItem.groupNames;
            if (groupNames != null) {
                for (String groupName : groupNames) {
                    item.addGroupName(groupName);
                }
            }
            if ((tags = persistedItem.tags) != null) {
                for (String tag : tags) {
                    item.addTag(tag);
                }
            }
            item.setLabel(persistedItem.label);
            item.setCategory(persistedItem.category);
        }
    }

    @Override
    protected PersistedItem toPersistableElement(Item item) {
        PersistedItem persistedItem = new PersistedItem(item instanceof GroupItem ? ITEM_TYPE_GROUP : this.toItemFactoryName(item));
        if (item instanceof GroupItem) {
            GroupItem groupItem = (GroupItem)item;
            String baseItemType = null;
            Item baseItem = groupItem.getBaseItem();
            if (baseItem != null) {
                baseItemType = this.toItemFactoryName(baseItem);
            }
            persistedItem.baseItemType = baseItemType;
            this.addFunctionToPersisedItem(persistedItem, groupItem);
        }
        persistedItem.label = item.getLabel();
        persistedItem.groupNames = new ArrayList<String>(item.getGroupNames());
        persistedItem.tags = new HashSet<String>(item.getTags());
        persistedItem.category = item.getCategory();
        return persistedItem;
    }

    private void addFunctionToPersisedItem(PersistedItem persistedItem, GroupItem groupItem) {
        if (groupItem.getFunction() != null) {
            GroupFunctionDTO functionDTO = ItemDTOMapper.mapFunction(groupItem.getFunction());
            persistedItem.functionName = functionDTO.name;
            if (functionDTO.params != null) {
                persistedItem.functionParams = Arrays.asList(functionDTO.params);
            }
        }
    }

    @Override
    @Reference
    protected void setStorageService(StorageService storageService) {
        super.setStorageService(storageService);
    }

    @Override
    protected void unsetStorageService(StorageService storageService) {
        super.unsetStorageService(storageService);
    }

    public static class PersistedItem {
        public String baseItemType;
        public List<String> groupNames;
        public @NonNull String itemType;
        public Set<String> tags;
        public String label;
        public String category;
        public String functionName;
        public List<String> functionParams;

        public PersistedItem(@NonNull String itemType) {
            this.itemType = itemType;
        }
    }
}

