/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.items;

import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemUtil.class);

    private ItemUtil() {
    }

    public static boolean isValidItemName(String itemName) {
        return StringUtils.isNotEmpty((String)itemName) && itemName.matches("[a-zA-Z0-9_]*");
    }

    public static void assertValidItemName(String itemName) throws IllegalArgumentException {
        if (!ItemUtil.isValidItemName(itemName)) {
            throw new IllegalArgumentException("The specified name of the item '" + itemName + "' is not valid!");
        }
    }

    public static State convertToAcceptedState(State state, Item item) {
        if (state == null) {
            LOGGER.error("A conversion of null was requested", (Throwable)new NullPointerException("state should not be null"));
            return UnDefType.NULL;
        }
        if (item != null && !ItemUtil.isAccepted(item, state)) {
            for (Class<? extends State> acceptedType : item.getAcceptedDataTypes()) {
                State convertedState = state.as(acceptedType);
                if (convertedState == null) continue;
                LOGGER.debug("Converting {} '{}' to {} '{}' for item '{}'", new Object[]{state.getClass().getSimpleName(), state, convertedState.getClass().getSimpleName(), convertedState, item.getName()});
                return convertedState;
            }
        }
        return state;
    }

    private static boolean isAccepted(Item item, State state) {
        return item.getAcceptedDataTypes().contains(state.getClass());
    }
}

