/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.items;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.core.common.ThreadPoolManager;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.ActiveItem;
import org.eclipse.smarthome.core.items.StateChangeListener;
import org.eclipse.smarthome.core.items.events.ItemEventFactory;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.StateDescriptionProvider;
import org.eclipse.smarthome.core.types.StateOption;
import org.eclipse.smarthome.core.types.UnDefType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericItem
implements ActiveItem {
    private final Logger logger = LoggerFactory.getLogger(GenericItem.class);
    private static final String ITEM_THREADPOOLNAME = "items";
    protected EventPublisher eventPublisher;
    protected Set<StateChangeListener> listeners = new CopyOnWriteArraySet(Collections.newSetFromMap(new WeakHashMap()));
    protected List<String> groupNames = new ArrayList<String>();
    protected Set<String> tags = new HashSet<String>();
    protected final @NonNull String name;
    protected final @NonNull String type;
    protected State state = UnDefType.NULL;
    protected String label;
    protected String category;
    private List<StateDescriptionProvider> stateDescriptionProviders;

    public GenericItem(@NonNull String type, @NonNull String name) {
        this.name = name;
        this.type = type;
    }

    @Override
    public State getState() {
        return this.state;
    }

    @Override
    public State getStateAs(Class<? extends State> typeClass) {
        return this.state.as(typeClass);
    }

    @Override
    public String getUID() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public List<String> getGroupNames() {
        return ImmutableList.copyOf(this.groupNames);
    }

    @Override
    public void addGroupName(String groupItemName) {
        if (groupItemName == null) {
            throw new IllegalArgumentException("Group item name must not be null!");
        }
        if (!this.groupNames.contains(groupItemName)) {
            this.groupNames.add(groupItemName);
        }
    }

    @Override
    public void addGroupNames(String ... groupItemNames) {
        String[] stringArray = groupItemNames;
        int n = groupItemNames.length;
        int n2 = 0;
        while (n2 < n) {
            String groupItemName = stringArray[n2];
            this.addGroupName(groupItemName);
            ++n2;
        }
    }

    @Override
    public void addGroupNames(List<String> groupItemNames) {
        for (String groupItemName : groupItemNames) {
            this.addGroupName(groupItemName);
        }
    }

    @Override
    public void removeGroupName(String groupItemName) {
        if (groupItemName == null) {
            throw new IllegalArgumentException("Group item name must not be null!");
        }
        this.groupNames.remove(groupItemName);
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setStateDescriptionProviders(List<StateDescriptionProvider> stateDescriptionProviders) {
        this.stateDescriptionProviders = stateDescriptionProviders;
    }

    protected void internalSend(Command command) {
        if (this.eventPublisher != null) {
            this.eventPublisher.post(ItemEventFactory.createCommandEvent(this.getName(), command));
        }
    }

    public void setState(State state) {
        this.applyState(state);
    }

    protected final void applyState(State state) {
        State oldState = this.state;
        this.state = state;
        this.notifyListeners(oldState, state);
        if (!oldState.equals(state)) {
            this.sendStateChangedEvent(state, oldState);
        }
    }

    private void sendStateChangedEvent(State newState, State oldState) {
        if (this.eventPublisher != null) {
            this.eventPublisher.post(ItemEventFactory.createStateChangedEvent(this.name, newState, oldState));
        }
    }

    public void send(RefreshType command) {
        this.internalSend(command);
    }

    protected void notifyListeners(final State oldState, final State newState) {
        CopyOnWriteArraySet<StateChangeListener> clonedListeners = null;
        clonedListeners = new CopyOnWriteArraySet<StateChangeListener>(this.listeners);
        ExecutorService pool = ThreadPoolManager.getPool(ITEM_THREADPOOLNAME);
        for (final StateChangeListener listener : clonedListeners) {
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        listener.stateUpdated(GenericItem.this, newState);
                        if (newState != null && !newState.equals(oldState)) {
                            listener.stateChanged(GenericItem.this, oldState, newState);
                        }
                    }
                    catch (Exception e) {
                        GenericItem.this.logger.warn("failed notifying listener '{}' about state update of item {}: {}", new Object[]{listener, GenericItem.this.getName(), e.getMessage(), e});
                    }
                }
            });
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(" (");
        sb.append("Type=");
        sb.append(this.getClass().getSimpleName());
        sb.append(", ");
        sb.append("State=");
        sb.append(this.getState());
        sb.append(", ");
        sb.append("Label=");
        sb.append(this.getLabel());
        sb.append(", ");
        sb.append("Category=");
        sb.append(this.getCategory());
        if (!this.getTags().isEmpty()) {
            sb.append(", ");
            sb.append("Tags=[");
            sb.append(Joiner.on((String)", ").join(this.getTags()));
            sb.append("]");
        }
        if (!this.getGroupNames().isEmpty()) {
            sb.append(", ");
            sb.append("Groups=[");
            sb.append(Joiner.on((String)", ").join(this.getGroupNames()));
            sb.append("]");
        }
        sb.append(")");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStateChangeListener(StateChangeListener listener) {
        Set<StateChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStateChangeListener(StateChangeListener listener) {
        Set<StateChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericItem other = (GenericItem)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public Set<String> getTags() {
        return ImmutableSet.copyOf(this.tags);
    }

    @Override
    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }

    @Override
    public void addTag(String tag) {
        this.tags.add(tag);
    }

    @Override
    public void addTags(Collection<String> tags) {
        this.tags.addAll(tags);
    }

    @Override
    public void addTags(String ... tags) {
        this.tags.addAll(Arrays.asList(tags));
    }

    @Override
    public void removeTag(String tag) {
        this.tags.remove(tag);
    }

    @Override
    public void removeAllTags() {
        this.tags.clear();
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public StateDescription getStateDescription() {
        return this.getStateDescription(null);
    }

    @Override
    public StateDescription getStateDescription(Locale locale) {
        StateDescription result = null;
        List<StateOption> stateOptions = Collections.emptyList();
        if (this.stateDescriptionProviders != null) {
            for (StateDescriptionProvider stateDescriptionProvider : this.stateDescriptionProviders) {
                StateDescription stateDescription = stateDescriptionProvider.getStateDescription(this.name, locale);
                if (result == null) {
                    result = stateDescription;
                }
                if (stateDescription == null || stateDescription.getOptions().isEmpty() || !stateOptions.isEmpty()) continue;
                stateOptions = stateDescription.getOptions();
            }
        }
        if (result != null && !stateOptions.isEmpty()) {
            result = new StateDescription(result.getMinimum(), result.getMaximum(), result.getStep(), result.getPattern(), result.isReadOnly(), stateOptions);
        }
        return result;
    }

    public boolean isAcceptedState(List<Class<? extends State>> acceptedDataTypes, State state) {
        return acceptedDataTypes.stream().map(clazz -> clazz.isAssignableFrom(state.getClass())).filter(found -> found).findAny().isPresent();
    }

    protected void logSetTypeError(State state) {
        this.logger.error("Tried to set invalid state {} ({}) on item {} of type {}, ignoring it", new Object[]{state, state.getClass().getSimpleName(), this.getName(), this.getClass().getSimpleName()});
    }
}

