/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionProvider;
import org.eclipse.smarthome.config.core.ConfigDescriptionRegistry;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeRegistry;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.eclipse.smarthome.core.thing.type.ThingTypeRegistry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class ThingConfigDescriptionProvider
implements ConfigDescriptionProvider {
    private ThingRegistry thingRegistry;
    private ThingTypeRegistry thingTypeRegistry;
    private ConfigDescriptionRegistry configDescriptionRegistry;
    private ChannelTypeRegistry channelTypeRegistry;

    @Reference
    protected void setConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescriptionRegistry = configDescriptionRegistry;
    }

    protected void unsetConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescriptionRegistry = null;
    }

    @Reference
    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = null;
    }

    @Reference
    protected void setThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = thingTypeRegistry;
    }

    protected void unsetThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = null;
    }

    @Reference
    protected void setChannelTypeRegistry(ChannelTypeRegistry channelTypeRegistry) {
        this.channelTypeRegistry = channelTypeRegistry;
    }

    protected void unsetChannelTypeRegistry(ChannelTypeRegistry channelTypeRegistry) {
        this.channelTypeRegistry = null;
    }

    public Collection<ConfigDescription> getConfigDescriptions(Locale locale) {
        return Collections.emptySet();
    }

    public ConfigDescription getConfigDescription(URI uri, Locale locale) {
        if (uri == null || uri.getScheme() == null) {
            return null;
        }
        switch (uri.getScheme()) {
            case "thing": {
                return this.getThingConfigDescription(uri, locale);
            }
            case "channel": {
                return this.getChannelConfigDescription(uri, locale);
            }
        }
        return null;
    }

    private ConfigDescription getThingConfigDescription(URI uri, Locale locale) {
        ThingUID thingUID = new ThingUID(uri.getSchemeSpecificPart());
        Thing thing = this.thingRegistry.get(thingUID);
        if (thing == null) {
            return null;
        }
        ThingType thingType = this.thingTypeRegistry.getThingType(thing.getThingTypeUID());
        if (thingType == null) {
            return null;
        }
        URI configURI = thingType.getConfigDescriptionURI();
        if (configURI == null) {
            return null;
        }
        ConfigDescription config = this.configDescriptionRegistry.getConfigDescription(configURI, locale);
        if (config == null) {
            return null;
        }
        return config;
    }

    private ConfigDescription getChannelConfigDescription(URI uri, Locale locale) {
        ChannelUID channelUID;
        ThingUID thingUID;
        Thing thing;
        String stringUID = uri.getSchemeSpecificPart();
        if (uri.getFragment() != null) {
            stringUID = String.valueOf(stringUID) + "#" + uri.getFragment();
        }
        if ((thing = this.thingRegistry.get(thingUID = (channelUID = new ChannelUID(stringUID)).getThingUID())) == null) {
            return null;
        }
        Channel channel = thing.getChannel(channelUID.getId());
        if (channel == null) {
            return null;
        }
        ChannelType channelType = this.channelTypeRegistry.getChannelType(channel.getChannelTypeUID());
        if (channelType == null) {
            return null;
        }
        URI configURI = channelType.getConfigDescriptionURI();
        if (configURI == null) {
            return null;
        }
        ConfigDescription config = this.configDescriptionRegistry.getConfigDescription(configURI, locale);
        if (config == null) {
            return null;
        }
        return config;
    }
}

