/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.core.common.SafeCaller;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventFilter;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.events.EventSubscriber;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.events.ItemCommandEvent;
import org.eclipse.smarthome.core.items.events.ItemStateEvent;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.events.ChannelTriggeredEvent;
import org.eclipse.smarthome.core.thing.events.ThingEventFactory;
import org.eclipse.smarthome.core.thing.internal.ProfileContextImpl;
import org.eclipse.smarthome.core.thing.internal.profiles.ProfileCallbackImpl;
import org.eclipse.smarthome.core.thing.internal.profiles.SystemProfileFactory;
import org.eclipse.smarthome.core.thing.link.ItemChannelLink;
import org.eclipse.smarthome.core.thing.link.ItemChannelLinkRegistry;
import org.eclipse.smarthome.core.thing.profiles.Profile;
import org.eclipse.smarthome.core.thing.profiles.ProfileAdvisor;
import org.eclipse.smarthome.core.thing.profiles.ProfileCallback;
import org.eclipse.smarthome.core.thing.profiles.ProfileFactory;
import org.eclipse.smarthome.core.thing.profiles.ProfileTypeUID;
import org.eclipse.smarthome.core.thing.profiles.StateProfile;
import org.eclipse.smarthome.core.thing.profiles.TriggerProfile;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={EventSubscriber.class, CommunicationManager.class}, immediate=true)
public class CommunicationManager
implements EventSubscriber,
RegistryChangeListener<ItemChannelLink> {
    public static final long THINGHANDLER_EVENT_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    private static final Set<String> SUBSCRIBED_EVENT_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(ItemStateEvent.TYPE, ItemCommandEvent.TYPE, ChannelTriggeredEvent.TYPE)));
    private final Logger logger = LoggerFactory.getLogger(CommunicationManager.class);
    private SystemProfileFactory defaultProfileFactory;
    private ItemChannelLinkRegistry itemChannelLinkRegistry;
    private ThingRegistry thingRegistry;
    private ItemRegistry itemRegistry;
    private EventPublisher eventPublisher;
    private SafeCaller safeCaller;
    private final Map<String, Profile> profiles = new ConcurrentHashMap<String, Profile>();
    private final Map<ProfileFactory, Set<String>> profileFactories = new ConcurrentHashMap<ProfileFactory, Set<String>>();
    private final Set<ProfileAdvisor> profileAdvisors = new CopyOnWriteArraySet<ProfileAdvisor>();

    public Set<String> getSubscribedEventTypes() {
        return SUBSCRIBED_EVENT_TYPES;
    }

    public EventFilter getEventFilter() {
        return null;
    }

    public void receive(Event event) {
        if (event instanceof ItemStateEvent) {
            this.receiveUpdate((ItemStateEvent)event);
        } else if (event instanceof ItemCommandEvent) {
            this.receiveCommand((ItemCommandEvent)event);
        } else if (event instanceof ChannelTriggeredEvent) {
            this.receiveTrigger((ChannelTriggeredEvent)event);
        }
    }

    private Thing getThing(ThingUID thingUID) {
        return this.thingRegistry.get(thingUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Profile getProfile(ItemChannelLink link, Item item, Thing thing) {
        Map<String, Profile> map = this.profiles;
        synchronized (map) {
            Profile profile = this.profiles.get(link.getUID());
            if (profile != null) {
                return profile;
            }
            ProfileTypeUID profileTypeUID = this.determineProfileTypeUID(link, item, thing);
            if (profileTypeUID != null && (profile = this.getProfileFromFactories(profileTypeUID, link, this.createCallback(link))) != null) {
                this.profiles.put(link.getUID(), profile);
                return profile;
            }
            return new NoOpProfile();
        }
    }

    private ProfileCallback createCallback(ItemChannelLink link) {
        return new ProfileCallbackImpl(this.eventPublisher, this.safeCaller, link, thingUID -> this.getThing((ThingUID)thingUID), itemName -> this.getItem((String)itemName));
    }

    private ProfileTypeUID determineProfileTypeUID(ItemChannelLink link, Item item, Thing thing) {
        ProfileTypeUID profileTypeUID = this.getConfiguredProfileTypeUID(link);
        Channel channel = null;
        if (profileTypeUID == null) {
            if (thing == null) {
                return null;
            }
            channel = thing.getChannel(link.getLinkedUID().getId());
            if (channel == null) {
                return null;
            }
            profileTypeUID = this.getAdvice(link, item, channel);
            if (profileTypeUID == null) {
                this.logger.trace("No profile advisor found for link {}, falling back to the defaults", (Object)link);
                profileTypeUID = this.defaultProfileFactory.getSuggestedProfileTypeUID(channel, item.getType());
            }
        }
        return profileTypeUID;
    }

    private ProfileTypeUID getAdvice(ItemChannelLink link, Item item, Channel channel) {
        for (ProfileAdvisor advisor : this.profileAdvisors) {
            ProfileTypeUID ret = advisor.getSuggestedProfileTypeUID(channel, item.getType());
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private ProfileTypeUID getConfiguredProfileTypeUID(ItemChannelLink link) {
        String profileName = (String)link.getConfiguration().get("profile");
        if (profileName != null && !profileName.trim().isEmpty()) {
            profileName = this.normalizeProfileName(profileName);
            return new ProfileTypeUID(profileName);
        }
        return null;
    }

    private String normalizeProfileName(String profileName) {
        if (!profileName.contains(":")) {
            return "system:" + profileName;
        }
        return profileName;
    }

    private Profile getProfileFromFactories(ProfileTypeUID profileTypeUID, ItemChannelLink link, ProfileCallback callback) {
        ProfileContextImpl context = new ProfileContextImpl(link.getConfiguration());
        if (this.supportsProfileTypeUID(this.defaultProfileFactory, profileTypeUID)) {
            this.logger.trace("using the default ProfileFactory to create profile '{}'", (Object)profileTypeUID);
            return this.defaultProfileFactory.createProfile(profileTypeUID, callback, context);
        }
        for (Map.Entry<ProfileFactory, Set<String>> entry : this.profileFactories.entrySet()) {
            ProfileFactory factory = entry.getKey();
            if (!this.supportsProfileTypeUID(factory, profileTypeUID)) continue;
            this.logger.trace("using ProfileFactory '{}' to create profile '{}'", (Object)factory, (Object)profileTypeUID);
            Profile profile = factory.createProfile(profileTypeUID, callback, context);
            if (profile == null) {
                this.logger.error("ProfileFactory {} returned 'null' although it claimed it supports {}", (Object)factory, (Object)profileTypeUID);
                continue;
            }
            entry.getValue().add(link.getUID());
            return profile;
        }
        this.logger.warn("no ProfileFactory found which supports '{}'", (Object)profileTypeUID);
        return null;
    }

    private boolean supportsProfileTypeUID(ProfileFactory profileFactory, ProfileTypeUID profileTypeUID) {
        return profileFactory.getSupportedProfileTypeUIDs().contains(profileTypeUID);
    }

    private void receiveCommand(ItemCommandEvent commandEvent) {
        String itemName = commandEvent.getItemName();
        Command command = commandEvent.getItemCommand();
        Item item = this.getItem(itemName);
        if (item == null) {
            this.logger.debug("Received an ItemCommandEvent for item {} which does not exist", (Object)itemName);
            return;
        }
        this.itemChannelLinkRegistry.stream().filter(link -> link.getItemName().equals(itemName)).filter(link -> !link.getLinkedUID().toString().equals(commandEvent.getSource())).forEach(link -> {
            Profile profile;
            ThingHandler handler;
            ChannelUID channelUID = link.getLinkedUID();
            Thing thing = this.getThing(channelUID.getThingUID());
            if (thing != null && (handler = thing.getHandler()) != null && (profile = this.getProfile((ItemChannelLink)link, item, thing)) instanceof StateProfile) {
                ((StateProfile)this.safeCaller.create((Object)((StateProfile)profile)).withAsync().withIdentifier((Object)thing).withTimeout(THINGHANDLER_EVENT_TIMEOUT).build()).onCommandFromItem(command);
            }
        });
    }

    private void receiveUpdate(ItemStateEvent updateEvent) {
        String itemName = updateEvent.getItemName();
        State newState = updateEvent.getItemState();
        Item item = this.getItem(itemName);
        if (item == null) {
            this.logger.debug("Received an ItemStateEvent for item {} which does not exist", (Object)itemName);
            return;
        }
        this.itemChannelLinkRegistry.stream().filter(link -> link.getItemName().equals(itemName)).filter(link -> !link.getLinkedUID().toString().equals(updateEvent.getSource())).forEach(link -> {
            ThingHandler handler;
            ChannelUID channelUID = link.getLinkedUID();
            Thing thing = this.getThing(channelUID.getThingUID());
            if (thing != null && (handler = thing.getHandler()) != null) {
                Profile profile = this.getProfile((ItemChannelLink)link, item, thing);
                ((Profile)this.safeCaller.create((Object)profile).withAsync().withIdentifier((Object)handler).withTimeout(THINGHANDLER_EVENT_TIMEOUT).build()).onStateUpdateFromItem(newState);
            }
        });
    }

    private Item getItem(String itemName) {
        return (Item)this.itemRegistry.get((Object)itemName);
    }

    private void receiveTrigger(ChannelTriggeredEvent channelTriggeredEvent) {
        ChannelUID channelUID = channelTriggeredEvent.getChannel();
        String event = channelTriggeredEvent.getEvent();
        Thing thing = this.getThing(channelUID.getThingUID());
        this.itemChannelLinkRegistry.stream().filter(link -> link.getLinkedUID().equals(channelUID)).forEach(link -> {
            Profile profile;
            Item item = this.getItem(link.getItemName());
            if (item != null && (profile = this.getProfile((ItemChannelLink)link, item, thing)) instanceof TriggerProfile) {
                ((TriggerProfile)profile).onTriggerFromHandler(event);
            }
        });
    }

    public void stateUpdated(ChannelUID channelUID, State state) {
        Thing thing = this.getThing(channelUID.getThingUID());
        this.itemChannelLinkRegistry.stream().filter(link -> link.getLinkedUID().equals(channelUID)).forEach(link -> {
            Profile profile;
            Item item = this.getItem(link.getItemName());
            if (item != null && (profile = this.getProfile((ItemChannelLink)link, item, thing)) instanceof StateProfile) {
                ((StateProfile)profile).onStateUpdateFromHandler(state);
            }
        });
    }

    public void postCommand(ChannelUID channelUID, Command command) {
        Thing thing = this.getThing(channelUID.getThingUID());
        this.itemChannelLinkRegistry.stream().filter(link -> link.getLinkedUID().equals(channelUID)).forEach(link -> {
            Profile profile;
            Item item = this.getItem(link.getItemName());
            if (item != null && (profile = this.getProfile((ItemChannelLink)link, item, thing)) instanceof StateProfile) {
                ((StateProfile)profile).onCommandFromHandler(command);
            }
        });
    }

    public void channelTriggered(Thing thing, ChannelUID channelUID, String event) {
        this.eventPublisher.post((Event)ThingEventFactory.createTriggerEvent(event, channelUID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(ItemChannelLink link) {
        Map<String, Profile> map = this.profiles;
        synchronized (map) {
            this.profiles.remove(link.getUID());
        }
        this.profileFactories.values().forEach(list -> {
            boolean bl = list.remove(link.getUID());
        });
    }

    public void added(ItemChannelLink element) {
    }

    public void removed(ItemChannelLink element) {
        this.cleanup(element);
    }

    public void updated(ItemChannelLink oldElement, ItemChannelLink element) {
        this.cleanup(oldElement);
    }

    @Reference
    protected void setItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = itemChannelLinkRegistry;
        itemChannelLinkRegistry.addRegistryChangeListener(this);
    }

    protected void unsetItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = null;
    }

    @Reference
    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = null;
    }

    @Reference
    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    @Reference
    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addProfileFactory(ProfileFactory profileFactory) {
        this.profileFactories.put(profileFactory, ConcurrentHashMap.newKeySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeProfileFactory(ProfileFactory profileFactory) {
        Set<String> links = this.profileFactories.remove(profileFactory);
        Map<String, Profile> map = this.profiles;
        synchronized (map) {
            links.forEach(link -> this.profiles.remove(link));
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addProfileAdvisor(ProfileAdvisor profileAdvisor) {
        this.profileAdvisors.add(profileAdvisor);
    }

    protected void removeProfileAdvisor(ProfileAdvisor profileAdvisor) {
        this.profileAdvisors.remove(profileAdvisor);
    }

    @Reference
    protected void setDefaultProfileFactory(SystemProfileFactory defaultProfileFactory) {
        this.defaultProfileFactory = defaultProfileFactory;
    }

    protected void unsetDefaultProfileFactory(SystemProfileFactory defaultProfileFactory) {
        this.defaultProfileFactory = null;
    }

    @Reference
    protected void setSafeCaller(SafeCaller safeCaller) {
        this.safeCaller = safeCaller;
    }

    protected void unsetSafeCaller(SafeCaller safeCaller) {
        this.safeCaller = null;
    }

    private static class NoOpProfile
    implements Profile {
        private NoOpProfile() {
        }

        @Override
        public @NonNull ProfileTypeUID getProfileTypeUID() {
            return new ProfileTypeUID("system", "noop");
        }

        @Override
        public void onStateUpdateFromItem(@NonNull State state) {
        }
    }
}

