/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.i18n;

import java.util.Locale;
import org.eclipse.smarthome.core.i18n.I18nUtil;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.type.ChannelDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeUID;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.osgi.framework.Bundle;

public class ThingTypeI18nUtil {
    private TranslationProvider i18nProvider;

    public ThingTypeI18nUtil(TranslationProvider i18nProvider) {
        this.i18nProvider = i18nProvider;
    }

    public String getChannelDescription(Bundle bundle, ChannelTypeUID channelTypeUID, String defaultDescription, Locale locale) {
        String key = I18nUtil.isConstant((String)defaultDescription) ? I18nUtil.stripConstant((String)defaultDescription) : this.inferChannelKey(channelTypeUID, "description");
        return this.i18nProvider.getText(bundle, key, defaultDescription, locale);
    }

    public String getChannelDescription(Bundle bundle, ThingTypeUID thingTypeUID, ChannelDefinition channel, String defaultDescription, Locale locale) {
        String key = I18nUtil.isConstant((String)defaultDescription) ? I18nUtil.stripConstant((String)defaultDescription) : this.inferThingTypeKey(thingTypeUID, channel, "description");
        return this.i18nProvider.getText(bundle, key, defaultDescription, locale);
    }

    public String getChannelGroupDescription(Bundle bundle, ChannelGroupTypeUID channelGroupTypeUID, String defaultDescription, Locale locale) {
        String key = I18nUtil.isConstant((String)defaultDescription) ? I18nUtil.stripConstant((String)defaultDescription) : this.inferChannelKey(channelGroupTypeUID, "description");
        return this.i18nProvider.getText(bundle, key, defaultDescription, locale);
    }

    public String getChannelGroupDescription(Bundle bundle, ThingTypeUID thingTypeUID, ChannelGroupDefinition channelGroup, String defaultDescription, Locale locale) {
        String key = I18nUtil.isConstant((String)defaultDescription) ? I18nUtil.stripConstant((String)defaultDescription) : this.inferThingTypeKey(thingTypeUID, channelGroup, "description");
        return this.i18nProvider.getText(bundle, key, defaultDescription, locale);
    }

    public String getChannelLabel(Bundle bundle, ChannelTypeUID channelTypeUID, String defaultLabel, Locale locale) {
        String key = I18nUtil.isConstant((String)defaultLabel) ? I18nUtil.stripConstant((String)defaultLabel) : this.inferChannelKey(channelTypeUID, "label");
        return this.i18nProvider.getText(bundle, key, defaultLabel, locale);
    }

    public String getChannelLabel(Bundle bundle, ThingTypeUID thingTypeUID, ChannelDefinition channel, String defaultLabel, Locale locale) {
        String key = I18nUtil.isConstant((String)defaultLabel) ? I18nUtil.stripConstant((String)defaultLabel) : this.inferThingTypeKey(thingTypeUID, channel, "label");
        return this.i18nProvider.getText(bundle, key, defaultLabel, locale);
    }

    public String getChannelGroupLabel(Bundle bundle, ChannelGroupTypeUID channelGroupTypeUID, String defaultLabel, Locale locale) {
        String key = I18nUtil.isConstant((String)defaultLabel) ? I18nUtil.stripConstant((String)defaultLabel) : this.inferChannelKey(channelGroupTypeUID, "label");
        return this.i18nProvider.getText(bundle, key, defaultLabel, locale);
    }

    public String getChannelGroupLabel(Bundle bundle, ThingTypeUID thingTypeUID, ChannelGroupDefinition channelGroup, String defaultLabel, Locale locale) {
        String key = I18nUtil.isConstant((String)defaultLabel) ? I18nUtil.stripConstant((String)defaultLabel) : this.inferThingTypeKey(thingTypeUID, channelGroup, "label");
        return this.i18nProvider.getText(bundle, key, defaultLabel, locale);
    }

    public String getChannelStateOption(Bundle bundle, ChannelTypeUID channelTypeUID, String optionValue, String defaultOptionLabel, Locale locale) {
        String key = I18nUtil.isConstant((String)defaultOptionLabel) ? I18nUtil.stripConstant((String)defaultOptionLabel) : this.inferChannelKey(channelTypeUID, "state.option." + optionValue);
        return this.i18nProvider.getText(bundle, key, defaultOptionLabel, locale);
    }

    public String getChannelStatePattern(Bundle bundle, ChannelTypeUID channelTypeUID, String defaultPattern, Locale locale) {
        String key = I18nUtil.isConstant((String)defaultPattern) ? I18nUtil.stripConstant((String)defaultPattern) : this.inferChannelKey(channelTypeUID, "state.pattern");
        return this.i18nProvider.getText(bundle, key, defaultPattern, locale);
    }

    public String getDescription(Bundle bundle, ThingTypeUID thingTypeUID, String defaultDescription, Locale locale) {
        String key = I18nUtil.isConstant((String)defaultDescription) ? I18nUtil.stripConstant((String)defaultDescription) : this.inferThingTypeKey(thingTypeUID, "description");
        return this.i18nProvider.getText(bundle, key, defaultDescription, locale);
    }

    public String getLabel(Bundle bundle, ThingTypeUID thingTypeUID, String defaultLabel, Locale locale) {
        String key = I18nUtil.isConstant((String)defaultLabel) ? I18nUtil.stripConstant((String)defaultLabel) : this.inferThingTypeKey(thingTypeUID, "label");
        return this.i18nProvider.getText(bundle, key, defaultLabel, locale);
    }

    private String inferChannelKey(ChannelGroupTypeUID channelGroupTypeUID, String lastSegment) {
        return "channel-group-type." + channelGroupTypeUID.getBindingId() + "." + channelGroupTypeUID.getId() + "." + lastSegment;
    }

    private String inferChannelKey(ChannelTypeUID channelTypeUID, String lastSegment) {
        return "channel-type." + channelTypeUID.getBindingId() + "." + channelTypeUID.getId() + "." + lastSegment;
    }

    private String inferThingTypeKey(ThingTypeUID thingTypeUID, String lastSegment) {
        return "thing-type." + thingTypeUID.getBindingId() + "." + thingTypeUID.getId() + "." + lastSegment;
    }

    private String inferThingTypeKey(ThingTypeUID thingTypeUID, ChannelGroupDefinition channelGroup, String lastSegment) {
        return "thing-type." + thingTypeUID.getBindingId() + "." + thingTypeUID.getId() + ".group." + channelGroup.getId() + "." + lastSegment;
    }

    private String inferThingTypeKey(ThingTypeUID thingTypeUID, ChannelDefinition channel, String lastSegment) {
        return "thing-type." + thingTypeUID.getBindingId() + "." + thingTypeUID.getId() + ".channel." + channel.getId() + "." + lastSegment;
    }
}

