/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.i18n;

import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.eclipse.smarthome.core.thing.i18n.ThingTypeI18nUtil;
import org.eclipse.smarthome.core.thing.type.BridgeType;
import org.eclipse.smarthome.core.thing.type.ChannelDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupType;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.eclipse.smarthome.core.thing.type.ThingTypeBuilder;
import org.eclipse.smarthome.core.thing.type.TypeResolver;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ThingTypeI18nLocalizationService.class})
@NonNullByDefault
public class ThingTypeI18nLocalizationService {
    @NonNullByDefault(value={})
    private ThingTypeI18nUtil thingTypeI18nUtil;

    @Reference
    protected void setTranslationProvider(TranslationProvider i18nProvider) {
        this.thingTypeI18nUtil = new ThingTypeI18nUtil(i18nProvider);
    }

    protected void unsetTranslationProvider(TranslationProvider i18nProvider) {
        this.thingTypeI18nUtil = null;
    }

    public ThingType createLocalizedThingType(Bundle bundle, ThingType thingType, Locale locale) {
        String label = this.thingTypeI18nUtil.getLabel(bundle, thingType.getUID(), thingType.getLabel(), locale);
        String description = this.thingTypeI18nUtil.getDescription(bundle, thingType.getUID(), thingType.getDescription(), locale);
        ArrayList<ChannelDefinition> localizedChannelDefinitions = new ArrayList<ChannelDefinition>(thingType.getChannelDefinitions().size());
        for (ChannelDefinition channelDefinition : thingType.getChannelDefinitions()) {
            ChannelType channelType;
            String channelLabel = this.thingTypeI18nUtil.getChannelLabel(bundle, thingType.getUID(), channelDefinition, channelDefinition.getLabel(), locale);
            String channelDescription = this.thingTypeI18nUtil.getChannelDescription(bundle, thingType.getUID(), channelDefinition, channelDefinition.getDescription(), locale);
            if ((channelLabel == null || channelDescription == null) && (channelType = TypeResolver.resolve(channelDefinition.getChannelTypeUID(), locale)) != null) {
                if (channelLabel == null) {
                    channelLabel = this.thingTypeI18nUtil.getChannelLabel(bundle, channelType.getUID(), channelType.getLabel(), locale);
                }
                if (channelDescription == null) {
                    channelDescription = this.thingTypeI18nUtil.getChannelDescription(bundle, channelType.getUID(), channelType.getDescription(), locale);
                }
            }
            localizedChannelDefinitions.add(new ChannelDefinition(channelDefinition.getId(), channelDefinition.getChannelTypeUID(), channelDefinition.getProperties(), channelLabel, channelDescription));
        }
        ArrayList<@NonNull ChannelGroupDefinition> localizedChannelGroupDefinitions = new ArrayList<ChannelGroupDefinition>(thingType.getChannelGroupDefinitions().size());
        for (ChannelGroupDefinition channelGroupDefinition : thingType.getChannelGroupDefinitions()) {
            ChannelGroupType channelGroupType;
            String channelGroupLabel = this.thingTypeI18nUtil.getChannelGroupLabel(bundle, thingType.getUID(), channelGroupDefinition, channelGroupDefinition.getLabel(), locale);
            String channelGroupDescription = this.thingTypeI18nUtil.getChannelGroupDescription(bundle, thingType.getUID(), channelGroupDefinition, channelGroupDefinition.getDescription(), locale);
            if ((channelGroupLabel == null || channelGroupDescription == null) && (channelGroupType = TypeResolver.resolve(channelGroupDefinition.getTypeUID(), locale)) != null) {
                if (channelGroupLabel == null) {
                    channelGroupLabel = this.thingTypeI18nUtil.getChannelGroupLabel(bundle, channelGroupType.getUID(), channelGroupType.getLabel(), locale);
                }
                if (channelGroupDescription == null) {
                    channelGroupDescription = this.thingTypeI18nUtil.getChannelGroupDescription(bundle, channelGroupType.getUID(), channelGroupType.getDescription(), locale);
                }
            }
            localizedChannelGroupDefinitions.add(new ChannelGroupDefinition(channelGroupDefinition.getId(), channelGroupDefinition.getTypeUID(), channelGroupLabel, channelGroupDescription));
        }
        ThingTypeBuilder builder = ThingTypeBuilder.instance(thingType).withLabel(label).withDescription(description).withChannelDefinitions(localizedChannelDefinitions).withChannelGroupDefinitions(localizedChannelGroupDefinitions);
        if (thingType instanceof BridgeType) {
            return builder.buildBridge();
        }
        return builder.build();
    }
}

