/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.firmware;

import org.eclipse.smarthome.core.events.AbstractEvent;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.firmware.FirmwareUpdateProgressInfo;

public final class FirmwareUpdateProgressInfoEvent
extends AbstractEvent {
    public static final String TYPE = FirmwareUpdateProgressInfoEvent.class.getSimpleName();
    private final FirmwareUpdateProgressInfo progressInfo;
    private final ThingUID thingUID;

    protected FirmwareUpdateProgressInfoEvent(String topic, String payload, FirmwareUpdateProgressInfo progressInfo, ThingUID thingUID) {
        super(topic, payload, null);
        this.progressInfo = progressInfo;
        this.thingUID = thingUID;
    }

    public FirmwareUpdateProgressInfo getProgressInfo() {
        return this.progressInfo;
    }

    public ThingUID getThingUID() {
        return this.thingUID;
    }

    public String getType() {
        return TYPE;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.progressInfo == null ? 0 : this.progressInfo.hashCode());
        result = 31 * result + (this.thingUID == null ? 0 : this.thingUID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        FirmwareUpdateProgressInfoEvent other = (FirmwareUpdateProgressInfoEvent)((Object)obj);
        if (this.progressInfo == null ? other.progressInfo != null : !this.progressInfo.equals(other.progressInfo)) {
            return false;
        }
        return !(this.thingUID == null ? other.thingUID != null : !this.thingUID.equals(other.thingUID));
    }

    public String toString() {
        String stepName = this.progressInfo.getProgressStep() == null ? null : this.progressInfo.getProgressStep().name();
        return String.format("The firmware update progress for thing %s changed. Step: %s Progress: %d.", this.thingUID, stepName, this.progressInfo.getProgress());
    }
}

