/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.firmware;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.eclipse.smarthome.core.thing.binding.firmware.FirmwareUID;
import org.eclipse.smarthome.core.thing.binding.firmware.ProgressStep;

public final class FirmwareUpdateProgressInfo {
    private FirmwareUID firmwareUID;
    private ProgressStep progressStep;
    private Collection<ProgressStep> sequence;
    private boolean pending;
    private Integer progress;

    protected FirmwareUpdateProgressInfo() {
    }

    FirmwareUpdateProgressInfo(FirmwareUID firmwareUID, ProgressStep progressStep, Collection<ProgressStep> sequence, boolean pending, int progress) {
        Preconditions.checkNotNull((Object)firmwareUID, (Object)"Firmware UID must not be null.");
        Preconditions.checkArgument((progress >= 0 && progress <= 100 ? 1 : 0) != 0, (Object)"The progress must be between 0 and 100.");
        this.firmwareUID = firmwareUID;
        this.progressStep = progressStep;
        this.sequence = sequence;
        this.pending = pending;
        this.progress = progress;
    }

    FirmwareUpdateProgressInfo(FirmwareUID firmwareUID, ProgressStep progressStep, Collection<ProgressStep> sequence, boolean pending) {
        Preconditions.checkNotNull((Object)firmwareUID, (Object)"Firmware UID must not be null.");
        Preconditions.checkArgument((sequence != null && !sequence.isEmpty() ? 1 : 0) != 0, (Object)"Sequence must not be null or empty.");
        Preconditions.checkNotNull((Object)((Object)progressStep), (Object)"Progress step must not be null.");
        this.firmwareUID = firmwareUID;
        this.progressStep = progressStep;
        this.sequence = sequence;
        this.pending = pending;
        this.progress = null;
    }

    public FirmwareUID getFirmwareUID() {
        return this.firmwareUID;
    }

    public ProgressStep getProgressStep() {
        return this.progressStep;
    }

    public Collection<ProgressStep> getSequence() {
        return this.sequence;
    }

    public boolean isPending() {
        return this.pending;
    }

    public Integer getProgress() {
        return this.progress;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.firmwareUID == null ? 0 : this.firmwareUID.hashCode());
        result = 31 * result + (this.pending ? 1231 : 1237);
        result = 31 * result + this.progress;
        result = 31 * result + (this.progressStep == null ? 0 : this.progressStep.hashCode());
        result = 31 * result + (this.sequence == null ? 0 : this.sequence.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirmwareUpdateProgressInfo)) {
            return false;
        }
        FirmwareUpdateProgressInfo other = (FirmwareUpdateProgressInfo)obj;
        if (this.firmwareUID == null ? other.firmwareUID != null : !this.firmwareUID.equals(other.firmwareUID)) {
            return false;
        }
        if (this.pending != other.pending) {
            return false;
        }
        if (!this.progress.equals(other.progress)) {
            return false;
        }
        if (this.progressStep != other.progressStep) {
            return false;
        }
        return !(this.sequence == null ? other.sequence != null : !this.sequence.equals(other.sequence));
    }

    public String toString() {
        return "FirmwareUpdateProgressInfo [firmwareUID=" + this.firmwareUID + ", progressStep=" + (Object)((Object)this.progressStep) + ", sequence=" + this.sequence + ", pending=" + this.pending + ", progress=" + this.progress + "]";
    }
}

