/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.firmware;

import com.google.common.base.Preconditions;
import org.eclipse.smarthome.core.thing.binding.firmware.FirmwareUID;
import org.eclipse.smarthome.core.thing.firmware.FirmwareStatus;

public final class FirmwareStatusInfo {
    private FirmwareStatus firmwareStatus;
    private FirmwareUID updatableFirmwareUID;

    protected FirmwareStatusInfo() {
    }

    private FirmwareStatusInfo(FirmwareStatus firmwareStatus, FirmwareUID updatableFirmwareUID) {
        Preconditions.checkNotNull((Object)((Object)firmwareStatus), (Object)"Firmware status must not be null.");
        this.firmwareStatus = firmwareStatus;
        this.updatableFirmwareUID = updatableFirmwareUID;
    }

    static FirmwareStatusInfo createUnknownInfo() {
        return new FirmwareStatusInfo(FirmwareStatus.UNKNOWN, null);
    }

    static FirmwareStatusInfo createUpToDateInfo() {
        return new FirmwareStatusInfo(FirmwareStatus.UP_TO_DATE, null);
    }

    static FirmwareStatusInfo createUpdateAvailableInfo() {
        return new FirmwareStatusInfo(FirmwareStatus.UPDATE_AVAILABLE, null);
    }

    static FirmwareStatusInfo createUpdateExecutableInfo(FirmwareUID updatableFirmwareUID) {
        Preconditions.checkNotNull((Object)updatableFirmwareUID, (Object)"Updatable firmware UID must not be null.");
        return new FirmwareStatusInfo(FirmwareStatus.UPDATE_EXECUTABLE, updatableFirmwareUID);
    }

    public FirmwareStatus getFirmwareStatus() {
        return this.firmwareStatus;
    }

    public FirmwareUID getUpdatableFirmwareUID() {
        return this.updatableFirmwareUID;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.firmwareStatus == null ? 0 : this.firmwareStatus.hashCode());
        result = 31 * result + (this.updatableFirmwareUID == null ? 0 : this.updatableFirmwareUID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FirmwareStatusInfo other = (FirmwareStatusInfo)obj;
        if (this.firmwareStatus != other.firmwareStatus) {
            return false;
        }
        return !(this.updatableFirmwareUID == null ? other.updatableFirmwareUID != null : !this.updatableFirmwareUID.equals(other.updatableFirmwareUID));
    }

    public String toString() {
        return "FirmwareStatusInfo [firmwareStatus=" + (Object)((Object)this.firmwareStatus) + ", updatableFirmwareUID=" + this.updatableFirmwareUID + "]";
    }
}

