/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.binding.builder;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.internal.ThingImpl;
import org.eclipse.smarthome.core.thing.util.ThingHelper;

public class ThingBuilder {
    private @NonNull ThingImpl thing;

    protected ThingBuilder(@NonNull ThingImpl thing) {
        this.thing = thing;
    }

    public static @NonNull ThingBuilder create(@NonNull ThingTypeUID thingTypeUID, @NonNull String thingId) {
        ThingImpl thing = new ThingImpl(thingTypeUID, thingId);
        return new ThingBuilder(thing);
    }

    @Deprecated
    public static @NonNull ThingBuilder create(@NonNull ThingUID thingUID) {
        ThingImpl thing = new ThingImpl(thingUID);
        return new ThingBuilder(thing);
    }

    public static @NonNull ThingBuilder create(ThingTypeUID thingTypeUID, ThingUID thingUID) {
        ThingImpl thing = new ThingImpl(thingTypeUID, thingUID);
        return new ThingBuilder(thing);
    }

    public @NonNull ThingBuilder withLabel(String label) {
        this.thing.setLabel(label);
        return this;
    }

    public @NonNull ThingBuilder withChannel(Channel channel) {
        List<Channel> mutableThingChannels = this.thing.getChannelsMutable();
        ThingHelper.ensureUniqueChannels(mutableThingChannels, channel);
        mutableThingChannels.add(channel);
        return this;
    }

    public @NonNull ThingBuilder withChannels(Channel ... channels) {
        ThingHelper.ensureUniqueChannels(channels);
        this.thing.setChannels(Lists.newArrayList((Object[])channels));
        return this;
    }

    public @NonNull ThingBuilder withChannels(List<Channel> channels) {
        ThingHelper.ensureUniqueChannels(channels);
        this.thing.setChannels(Lists.newArrayList(channels));
        return this;
    }

    public @NonNull ThingBuilder withoutChannel(ChannelUID channelUID) {
        Iterator<Channel> iterator = this.thing.getChannelsMutable().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getUID().equals(channelUID)) continue;
            iterator.remove();
        }
        return this;
    }

    public @NonNull ThingBuilder withConfiguration(Configuration thingConfiguration) {
        this.thing.setConfiguration(thingConfiguration);
        return this;
    }

    public @NonNull ThingBuilder withBridge(ThingUID bridgeUID) {
        if (bridgeUID != null) {
            this.thing.setBridgeUID(bridgeUID);
        }
        return this;
    }

    public @NonNull ThingBuilder withProperties(Map<@NonNull String, String> properties) {
        if (properties != null) {
            for (String key : properties.keySet()) {
                this.thing.setProperty(key, properties.get(key));
            }
        }
        return this;
    }

    public @NonNull ThingBuilder withLocation(String location) {
        this.thing.setLocation(location);
        return this;
    }

    public @NonNull Thing build() {
        return this.thing;
    }
}

