/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;

public class ThingStatusInfo {
    private @NonNull ThingStatus status;
    private @NonNull ThingStatusDetail statusDetail;
    private String description;

    protected ThingStatusInfo() {
        this.status = ThingStatus.UNKNOWN;
        this.statusDetail = ThingStatusDetail.NONE;
    }

    public ThingStatusInfo(@NonNull ThingStatus status, @NonNull ThingStatusDetail statusDetail, String description) throws IllegalArgumentException {
        this.status = status;
        this.statusDetail = statusDetail;
        this.description = description;
    }

    public @NonNull ThingStatus getStatus() {
        return this.status;
    }

    public @NonNull ThingStatusDetail getStatusDetail() {
        return this.statusDetail;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return (Object)((Object)this.getStatus()) + (this.getStatusDetail() == ThingStatusDetail.NONE ? "" : " (" + (Object)((Object)this.getStatusDetail()) + ")") + (StringUtils.isBlank((String)this.getDescription()) ? "" : ": " + this.getDescription());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.statusDetail == null ? 0 : this.statusDetail.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThingStatusInfo other = (ThingStatusInfo)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        return this.statusDetail == other.statusDetail;
    }
}

