/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core.validation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.ConfigDescriptionRegistry;
import org.eclipse.smarthome.config.core.internal.Activator;
import org.eclipse.smarthome.config.core.validation.ConfigValidationException;
import org.eclipse.smarthome.config.core.validation.ConfigValidationMessage;
import org.eclipse.smarthome.config.core.validation.internal.ConfigDescriptionParameterValidator;
import org.eclipse.smarthome.config.core.validation.internal.ConfigDescriptionParameterValidatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigDescriptionValidator {
    private static final Logger logger = LoggerFactory.getLogger(ConfigDescriptionValidator.class);
    private static final List<ConfigDescriptionParameterValidator> validators = new ImmutableList.Builder().add((Object)ConfigDescriptionParameterValidatorFactory.createRequiredValidator()).add((Object)ConfigDescriptionParameterValidatorFactory.createTypeValidator()).add((Object)ConfigDescriptionParameterValidatorFactory.createMinMaxValidator()).add((Object)ConfigDescriptionParameterValidatorFactory.createPatternValidator()).build();

    private ConfigDescriptionValidator() {
    }

    public static void validate(Map<String, Object> configurationParameters, URI configDescriptionURI) {
        Preconditions.checkNotNull(configurationParameters, (Object)"Configuration parameters must not be null");
        Preconditions.checkNotNull((Object)configDescriptionURI, (Object)"Config description URI must not be null");
        ConfigDescription configDescription = ConfigDescriptionValidator.getConfigDescription(configDescriptionURI);
        if (configDescription == null) {
            logger.warn("Skipping config description validation because no config description found for URI '{}'", (Object)configDescriptionURI);
            return;
        }
        Map<String, ConfigDescriptionParameter> map = configDescription.toParametersMap();
        ArrayList<ConfigValidationMessage> configDescriptionValidationMessages = new ArrayList<ConfigValidationMessage>();
        for (String key : configurationParameters.keySet()) {
            ConfigDescriptionParameter configDescriptionParameter = map.get(key);
            if (configDescriptionParameter == null) continue;
            if (configDescriptionParameter.isMultiple().booleanValue() && configurationParameters.get(key) instanceof List) {
                for (Object value : (List)configurationParameters.get(key)) {
                    ConfigValidationMessage message = ConfigDescriptionValidator.validateParameter(configDescriptionParameter, value);
                    if (message == null) continue;
                    configDescriptionValidationMessages.add(message);
                }
                continue;
            }
            ConfigValidationMessage message = ConfigDescriptionValidator.validateParameter(configDescriptionParameter, configurationParameters.get(key));
            if (message == null) continue;
            configDescriptionValidationMessages.add(message);
        }
        if (!configDescriptionValidationMessages.isEmpty()) {
            throw new ConfigValidationException(Activator.getBundleContext().getBundle(), configDescriptionValidationMessages);
        }
    }

    private static ConfigValidationMessage validateParameter(ConfigDescriptionParameter configDescriptionParameter, Object value) {
        for (ConfigDescriptionParameterValidator validator : validators) {
            ConfigValidationMessage message = validator.validate(configDescriptionParameter, value);
            if (message == null) continue;
            return message;
        }
        return null;
    }

    private static ConfigDescription getConfigDescription(URI configDescriptionURI) {
        ConfigDescriptionRegistry configDescriptionRegistry = Activator.getConfigDescriptionRegistry();
        if (configDescriptionRegistry == null) {
            logger.warn("No config description registry available.");
            return null;
        }
        ConfigDescription configDescription = configDescriptionRegistry.getConfigDescription(configDescriptionURI);
        if (configDescription == null) {
            logger.warn("No config description found for URI '{}'", (Object)configDescriptionURI);
        }
        return configDescription;
    }
}

