/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core.status;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import org.eclipse.smarthome.config.core.status.ConfigStatusCallback;
import org.eclipse.smarthome.config.core.status.ConfigStatusInfo;
import org.eclipse.smarthome.config.core.status.ConfigStatusMessage;
import org.eclipse.smarthome.config.core.status.ConfigStatusProvider;
import org.eclipse.smarthome.config.core.status.ConfigStatusSource;
import org.eclipse.smarthome.config.core.status.events.ConfigStatusInfoEvent;
import org.eclipse.smarthome.core.common.ThreadPoolManager;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigStatusService
implements ConfigStatusCallback {
    private final Logger logger = LoggerFactory.getLogger(ConfigStatusService.class);
    private final List<ConfigStatusProvider> configStatusProviders = new CopyOnWriteArrayList<ConfigStatusProvider>();
    private EventPublisher eventPublisher;
    private LocaleProvider localeProvider;
    private TranslationProvider i18nProvider;
    private final ExecutorService executorService = ThreadPoolManager.getPool((String)ConfigStatusService.class.getSimpleName());

    public ConfigStatusInfo getConfigStatus(String entityId, Locale locale) {
        if (entityId == null || entityId.equals("")) {
            throw new IllegalArgumentException("EntityId must not be null or empty");
        }
        Locale loc = locale != null ? locale : this.localeProvider.getLocale();
        for (ConfigStatusProvider configStatusProvider : this.configStatusProviders) {
            if (!configStatusProvider.supportsEntity(entityId)) continue;
            return this.getConfigStatus(configStatusProvider, entityId, loc);
        }
        this.logger.debug("There is no config status provider for entity {} available.", (Object)entityId);
        return null;
    }

    @Override
    public void configUpdated(final ConfigStatusSource configStatusSource) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                ConfigStatusInfo info = ConfigStatusService.this.getConfigStatus(configStatusSource.entityId, null);
                if (info != null) {
                    if (ConfigStatusService.this.eventPublisher != null) {
                        ConfigStatusService.this.eventPublisher.post((Event)new ConfigStatusInfoEvent(configStatusSource.getTopic(), info));
                    } else {
                        ConfigStatusService.this.logger.warn("EventPublisher not available. Cannot post new config status for entity {}", (Object)configStatusSource.entityId);
                    }
                }
            }
        });
    }

    private ConfigStatusInfo getConfigStatus(ConfigStatusProvider configStatusProvider, String entityId, Locale locale) {
        Collection<ConfigStatusMessage> configStatus = configStatusProvider.getConfigStatus();
        if (configStatus == null) {
            this.logger.debug("Cannot provide config status for entity {} because its config status provider returned null.", (Object)entityId);
            return null;
        }
        Bundle bundle = FrameworkUtil.getBundle(configStatusProvider.getClass());
        ConfigStatusInfo info = new ConfigStatusInfo();
        for (ConfigStatusMessage configStatusMessage : configStatus) {
            String message = null;
            if (configStatusMessage.messageKey != null && (message = this.i18nProvider.getText(bundle, configStatusMessage.messageKey, null, locale, configStatusMessage.arguments)) == null) {
                this.logger.warn("No translation found for key {} and config status provider {}. Will ignore the config status message.", (Object)configStatusMessage.messageKey, (Object)configStatusProvider.getClass().getSimpleName());
                continue;
            }
            info.add(new ConfigStatusMessage(configStatusMessage.parameterName, configStatusMessage.type, message, configStatusMessage.statusCode));
        }
        return info;
    }

    protected void addConfigStatusProvider(ConfigStatusProvider configStatusProvider) {
        configStatusProvider.setConfigStatusCallback(this);
        this.configStatusProviders.add(configStatusProvider);
    }

    protected void removeConfigStatusProvider(ConfigStatusProvider configStatusProvider) {
        configStatusProvider.setConfigStatusCallback(null);
        this.configStatusProviders.remove(configStatusProvider);
    }

    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    protected void setLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    protected void unsetLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = null;
    }

    protected void setTranslationProvider(TranslationProvider i18nProvider) {
        this.i18nProvider = i18nProvider;
    }

    protected void unsetTranslationProvider(TranslationProvider i18nProvider) {
        this.i18nProvider = null;
    }
}

