/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.wemo.internal.discovery;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.smarthome.binding.wemo.WemoBindingConstants;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.config.discovery.upnp.UpnpDiscoveryParticipant;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WemoDiscoveryParticipant
implements UpnpDiscoveryParticipant {
    private Logger logger = LoggerFactory.getLogger(WemoDiscoveryParticipant.class);

    public Set<ThingTypeUID> getSupportedThingTypeUIDs() {
        return WemoBindingConstants.SUPPORTED_THING_TYPES;
    }

    public DiscoveryResult createResult(RemoteDevice device) {
        ThingUID uid = this.getThingUID(device);
        if (uid != null) {
            HashMap<String, String> properties = new HashMap<String, String>(2);
            String label = "WeMo Device";
            try {
                label = device.getDetails().getFriendlyName();
            }
            catch (Exception exception) {}
            properties.put("udn", ((RemoteDeviceIdentity)device.getIdentity()).getUdn().getIdentifierString());
            DiscoveryResult result = DiscoveryResultBuilder.create((ThingUID)uid).withProperties(properties).withLabel(label).withRepresentationProperty("udn").build();
            this.logger.debug("Created a DiscoveryResult for device '{}' with UDN '{}'", (Object)device.getDetails().getFriendlyName(), (Object)((RemoteDeviceIdentity)device.getIdentity()).getUdn().getIdentifierString());
            return result;
        }
        return null;
    }

    public ThingUID getThingUID(RemoteDevice device) {
        if (device != null && device.getDetails().getManufacturerDetails().getManufacturer() != null && device.getDetails().getManufacturerDetails().getManufacturer().toUpperCase().contains("BELKIN") && device.getDetails().getModelDetails().getModelName() != null) {
            if (device.getDetails().getModelDetails().getModelName().toLowerCase().startsWith("socket")) {
                this.logger.debug("Discovered a WeMo Socket thing with UDN '{}'", (Object)((RemoteDeviceIdentity)device.getIdentity()).getUdn().getIdentifierString());
                return new ThingUID(WemoBindingConstants.THING_TYPE_SOCKET, ((RemoteDeviceIdentity)device.getIdentity()).getUdn().getIdentifierString());
            }
            if (device.getDetails().getModelDetails().getModelName().toLowerCase().startsWith("insight")) {
                this.logger.debug("Discovered a WeMo Insight thing with UDN '{}'", (Object)((RemoteDeviceIdentity)device.getIdentity()).getUdn().getIdentifierString());
                return new ThingUID(WemoBindingConstants.THING_TYPE_INSIGHT, ((RemoteDeviceIdentity)device.getIdentity()).getUdn().getIdentifierString());
            }
            if (device.getDetails().getModelDetails().getModelName().toLowerCase().startsWith("lightswitch")) {
                this.logger.debug("Discovered a WeMo Lightswitch thing with UDN '{}'", (Object)((RemoteDeviceIdentity)device.getIdentity()).getUdn().getIdentifierString());
                return new ThingUID(WemoBindingConstants.THING_TYPE_LIGHTSWITCH, ((RemoteDeviceIdentity)device.getIdentity()).getUdn().getIdentifierString());
            }
            if (device.getDetails().getModelDetails().getModelName().toLowerCase().startsWith("motion")) {
                this.logger.debug("Discovered a WeMo Motion thing with UDN '{}'", (Object)((RemoteDeviceIdentity)device.getIdentity()).getUdn().getIdentifierString());
                return new ThingUID(WemoBindingConstants.THING_TYPE_MOTION, ((RemoteDeviceIdentity)device.getIdentity()).getUdn().getIdentifierString());
            }
            if (device.getDetails().getModelDetails().getModelName().toLowerCase().startsWith("sensor")) {
                this.logger.debug("Discovered a WeMo Motion thing with UDN '{}'", (Object)((RemoteDeviceIdentity)device.getIdentity()).getUdn().getIdentifierString());
                return new ThingUID(WemoBindingConstants.THING_TYPE_MOTION, ((RemoteDeviceIdentity)device.getIdentity()).getUdn().getIdentifierString());
            }
            if (device.getDetails().getModelDetails().getModelName().toLowerCase().startsWith("bridge")) {
                this.logger.debug("Discovered a WeMo Bridge thing with UDN '{}'", (Object)((RemoteDeviceIdentity)device.getIdentity()).getUdn().getIdentifierString());
                return new ThingUID(WemoBindingConstants.THING_TYPE_BRIDGE, ((RemoteDeviceIdentity)device.getIdentity()).getUdn().getIdentifierString());
            }
            if (device.getDetails().getModelDetails().getModelName().toLowerCase().startsWith("maker")) {
                this.logger.debug("Discovered a WeMo Maker thing with UDN '{}'", (Object)((RemoteDeviceIdentity)device.getIdentity()).getUdn().getIdentifierString());
                return new ThingUID(WemoBindingConstants.THING_TYPE_MAKER, ((RemoteDeviceIdentity)device.getIdentity()).getUdn().getIdentifierString());
            }
            if (device.getDetails().getModelDetails().getModelName().toLowerCase().startsWith("coffee")) {
                this.logger.debug("Discovered a WeMo Coffe Maker thing with UDN '{}'", (Object)((RemoteDeviceIdentity)device.getIdentity()).getUdn().getIdentifierString());
                return new ThingUID(WemoBindingConstants.THING_TYPE_COFFEE, ((RemoteDeviceIdentity)device.getIdentity()).getUdn().getIdentifierString());
            }
        }
        return null;
    }
}

