/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.serialbutton.internal;

import java.util.Collections;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.serialbutton.SerialButtonBindingConstants;
import org.eclipse.smarthome.binding.serialbutton.handler.SerialButtonHandler;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.osgi.service.component.annotations.Component;

@Component(service={ThingHandlerFactory.class}, immediate=true, configurationPid="binding.serialbutton")
@NonNullByDefault
public class SerialButtonHandlerFactory
extends BaseThingHandlerFactory {
    private static final Set<ThingTypeUID> SUPPORTED_THING_TYPES_UIDS = Collections.singleton(SerialButtonBindingConstants.THING_TYPE_BUTTON);

    public boolean supportsThingType(ThingTypeUID thingTypeUID) {
        return SUPPORTED_THING_TYPES_UIDS.contains(thingTypeUID);
    }

    protected @Nullable ThingHandler createHandler(Thing thing) {
        ThingTypeUID thingTypeUID = thing.getThingTypeUID();
        if (thingTypeUID.equals((Object)SerialButtonBindingConstants.THING_TYPE_BUTTON)) {
            return new SerialButtonHandler(thing);
        }
        return null;
    }
}

