/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.core.handler;

import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.handler.BaseModuleHandler;
import org.eclipse.smarthome.automation.handler.ConditionHandler;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.TypeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemStateConditionHandler
extends BaseModuleHandler<Condition>
implements ConditionHandler {
    private final Logger logger = LoggerFactory.getLogger(ItemStateConditionHandler.class);
    public static final String ITEM_STATE_CONDITION = "core.ItemStateCondition";
    private ItemRegistry itemRegistry;
    private static final String ITEM_NAME = "itemName";
    private static final String OPERATOR = "operator";
    private static final String STATE = "state";

    public ItemStateConditionHandler(Condition condition) {
        super((Module)condition);
    }

    public void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    public void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    public void dispose() {
        this.itemRegistry = null;
    }

    public boolean isSatisfied(Map<String, Object> inputs) {
        String itemName = (String)((Condition)this.module).getConfiguration().get(ITEM_NAME);
        String state = (String)((Condition)this.module).getConfiguration().get(STATE);
        String operator = (String)((Condition)this.module).getConfiguration().get(OPERATOR);
        if (operator == null || state == null || itemName == null) {
            this.logger.error("Module is not well configured: itemName={}  operator={}  state = {}", new Object[]{itemName, operator, state});
            return false;
        }
        if (this.itemRegistry == null) {
            this.logger.error("The ItemRegistry is not available to evaluate the condition.");
            return false;
        }
        try {
            Item item = this.itemRegistry.getItem(itemName);
            State compareState = TypeParser.parseState((List)item.getAcceptedDataTypes(), (String)state);
            State itemState = item.getState();
            this.logger.debug("ItemStateCondition '{}'checking if {} (State={}) {} {}", new Object[]{((Condition)this.module).getId(), itemName, itemState, operator, compareState});
            switch (operator) {
                case "=": {
                    this.logger.debug("ConditionSatisfied --> {}", (Object)itemState.equals(compareState));
                    return itemState.equals(compareState);
                }
                case "!=": {
                    return !itemState.equals(compareState);
                }
                case "<": {
                    if (itemState instanceof DecimalType && compareState instanceof DecimalType) {
                        return ((DecimalType)itemState).compareTo((DecimalType)compareState) < 0;
                    }
                    break;
                }
                case "<=": 
                case "=<": {
                    if (itemState instanceof DecimalType && compareState instanceof DecimalType) {
                        return ((DecimalType)itemState).compareTo((DecimalType)compareState) <= 0;
                    }
                    break;
                }
                case ">": {
                    if (itemState instanceof DecimalType && compareState instanceof DecimalType) {
                        return ((DecimalType)itemState).compareTo((DecimalType)compareState) > 0;
                    }
                    break;
                }
                case "=>": 
                case ">=": {
                    if (itemState instanceof DecimalType && compareState instanceof DecimalType) {
                        return ((DecimalType)itemState).compareTo((DecimalType)compareState) >= 0;
                    }
                    break;
                }
            }
        }
        catch (ItemNotFoundException e) {
            this.logger.error("Item with Name {} not found in itemRegistry", (Object)itemName);
            return false;
        }
        return false;
    }
}

