/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.types;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.smarthome.core.types.StateOption;

public class StateDescription {
    private final BigDecimal minimum;
    private final BigDecimal maximum;
    private final BigDecimal step;
    private final String pattern;
    private final boolean readOnly;
    private final List<StateOption> options;

    public StateDescription(BigDecimal minimum, BigDecimal maximum, BigDecimal step, String pattern, boolean readOnly, List<StateOption> options) {
        this.minimum = minimum;
        this.maximum = maximum;
        this.step = step;
        this.pattern = pattern;
        this.readOnly = readOnly;
        this.options = options != null ? Collections.unmodifiableList(new ArrayList<StateOption>(options)) : Collections.unmodifiableList(new ArrayList(0));
    }

    public BigDecimal getMinimum() {
        return this.minimum;
    }

    public BigDecimal getMaximum() {
        return this.maximum;
    }

    public BigDecimal getStep() {
        return this.step;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public List<StateOption> getOptions() {
        return this.options;
    }

    public String toString() {
        return "StateDescription [minimum=" + this.minimum + ", maximum=" + this.maximum + ", step=" + this.step + ", pattern=" + this.pattern + ", readOnly=" + this.readOnly + ", channelStateOptions=" + this.options + "]";
    }
}

