/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.scheduler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.smarthome.core.common.ThreadPoolManager;
import org.eclipse.smarthome.core.scheduler.Expression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionThreadPoolManager
extends ThreadPoolManager {
    private static final Logger logger = LoggerFactory.getLogger(ExpressionThreadPoolManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExpressionThreadPoolExecutor getExpressionScheduledPool(String poolName) {
        ExecutorService pool = (ExecutorService)pools.get(poolName);
        if (pool == null) {
            Map map = pools;
            synchronized (map) {
                pool = (ExecutorService)pools.get(poolName);
                if (pool == null) {
                    int[] cfg = ExpressionThreadPoolManager.getConfig(poolName);
                    pool = new ExpressionThreadPoolExecutor(poolName, cfg[0]);
                    ((ThreadPoolExecutor)pool).setKeepAliveTime(65L, TimeUnit.SECONDS);
                    ((ThreadPoolExecutor)pool).allowCoreThreadTimeOut(true);
                    pools.put(poolName, pool);
                    logger.debug("Created an expression-drive scheduled thread pool '{}' of size {}", new Object[]{poolName, cfg[0]});
                }
            }
        }
        if (pool instanceof ExpressionThreadPoolExecutor) {
            return (ExpressionThreadPoolExecutor)pool;
        }
        throw new IllegalArgumentException("Pool " + poolName + " is not an expression-driven scheduled pool!");
    }

    public static class ExpressionThreadPoolExecutor
    extends ScheduledThreadPoolExecutor {
        private List<Runnable> running = Collections.synchronizedList(new ArrayList());
        private Map<Expression, Runnable> scheduled = Collections.synchronizedMap(new HashMap());
        private Map<Runnable, Future<?>> futures = Collections.synchronizedMap(new HashMap());
        private Map<Future<?>, Date> timestamps = Collections.synchronizedMap(new HashMap());
        private Thread monitor;
        private ThreadPoolManager.NamedThreadFactory monitorThreadFactory;
        Runnable monitorTask = new Runnable(){

            @Override
            public void run() {
                logger.trace("Starting the monitor thread '{}'", (Object)Thread.currentThread().getName());
                while (true) {
                    try {
                        block5: while (true) {
                            Date firstExecution = null;
                            Date now = new Date();
                            ArrayList<Expression> finishedExpressions = new ArrayList<Expression>();
                            for (Expression e : ExpressionThreadPoolExecutor.this.scheduled.keySet()) {
                                Date time = e.getTimeAfter(now);
                                if (time != null) {
                                    logger.trace("Expression's '{}' next execution time is {}", (Object)e.toString(), (Object)time.toString());
                                    Runnable task = (Runnable)ExpressionThreadPoolExecutor.this.scheduled.get(e);
                                    if (task != null) {
                                        Future future = (Future)ExpressionThreadPoolExecutor.this.futures.get(task);
                                        boolean schedule = false;
                                        if (future == null) {
                                            schedule = true;
                                        } else {
                                            Date timestamp = (Date)ExpressionThreadPoolExecutor.this.timestamps.get(future);
                                            if (time.after(timestamp)) {
                                                schedule = true;
                                            } else {
                                                logger.trace("The task '{}' is already scheduled to execute in {} ms", (Object)task.toString(), (Object)(time.getTime() - now.getTime()));
                                            }
                                        }
                                        if (schedule) {
                                            logger.trace("Scheduling the task '{}' to execute in {} ms", (Object)task.toString(), (Object)(time.getTime() - now.getTime()));
                                            ExpressionThreadPoolExecutor.this.futures.put(task, ExpressionThreadPoolExecutor.this.schedule(task, time.getTime() - now.getTime(), TimeUnit.MILLISECONDS));
                                            ExpressionThreadPoolExecutor.this.timestamps.put((Future)ExpressionThreadPoolExecutor.this.futures.get(task), time);
                                        }
                                    } else {
                                        logger.trace("Expressions without tasks are not valid");
                                    }
                                    if (firstExecution == null) {
                                        firstExecution = time;
                                        continue;
                                    }
                                    if (!time.before(firstExecution)) continue;
                                    firstExecution = time;
                                    continue;
                                }
                                logger.info("Expression '{}' has no future executions anymore", (Object)e.toString());
                                finishedExpressions.add(e);
                            }
                            for (Expression e : finishedExpressions) {
                                ExpressionThreadPoolExecutor.this.scheduled.remove(e);
                            }
                            if (firstExecution != null) {
                                while (true) {
                                    if (!now.before(firstExecution)) continue block5;
                                    logger.trace("Putting the monitor thread '{}' to sleep for {} ms", (Object)Thread.currentThread().getName(), (Object)(firstExecution.getTime() - now.getTime()));
                                    Thread.sleep(firstExecution.getTime() - now.getTime());
                                    now = new Date();
                                }
                            }
                            logger.trace("Putting the monitor thread '{}' to sleep for {} ms", (Object)Thread.currentThread().getName(), (Object)60000L);
                            Thread.sleep(60000L);
                        }
                    }
                    catch (RejectedExecutionException ex) {
                        logger.error("The executor has already shutdown : '{}'", (Object)ex.getMessage());
                        continue;
                    }
                    catch (CancellationException ex) {
                        logger.error("Non executed tasks are cancelled : '{}'", (Object)ex.getMessage());
                        continue;
                    }
                    catch (InterruptedException ex) {
                        logger.trace("The monitor thread as interrupted : '{}'", (Object)ex.getMessage());
                        continue;
                    }
                    break;
                }
            }
        };

        public ExpressionThreadPoolExecutor(final String poolName, int corePoolSize) {
            this(poolName, corePoolSize, new ThreadPoolManager.NamedThreadFactory(poolName), new ThreadPoolExecutor.DiscardPolicy(){

                @Override
                public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                    logger.warn("Thread pool '{}' rejected execution of {}", new Object[]{poolName, runnable.getClass()});
                    super.rejectedExecution(runnable, threadPoolExecutor);
                }
            });
        }

        public ExpressionThreadPoolExecutor(String threadPool, int corePoolSize, ThreadPoolManager.NamedThreadFactory threadFactory, RejectedExecutionHandler rejectedHandler) {
            super(corePoolSize, threadFactory, rejectedHandler);
            this.monitorThreadFactory = new ThreadPoolManager.NamedThreadFactory(String.valueOf(threadFactory.getName()) + "-" + "Monitor");
        }

        @Override
        protected void beforeExecute(Thread thread, Runnable runnable) {
            super.beforeExecute(thread, runnable);
            this.running.add(runnable);
        }

        @Override
        protected void afterExecute(Runnable runnable, Throwable throwable) {
            Throwable cause;
            super.afterExecute(runnable, throwable);
            this.running.remove(runnable);
            Future<?> future = this.futures.remove(runnable);
            this.timestamps.remove(future);
            if (throwable != null && (cause = throwable.getCause()) instanceof InterruptedException) {
                return;
            }
        }

        public void schedule(Runnable task, Expression expression) {
            if (task == null || expression == null) {
                throw new NullPointerException();
            }
            if (this.monitor == null) {
                this.monitor = this.monitorThreadFactory.newThread(this.monitorTask);
                this.monitor.start();
            }
            this.scheduled.put(expression, task);
            this.monitor.interrupt();
        }

        @Override
        public boolean remove(Runnable task) {
            if (this.futures.get(task) != null && this.futures.get(task).cancel(false)) {
                this.running.remove(task);
            }
            this.futures.remove(task);
            return super.remove(task);
        }

        public boolean remove(Expression expression) {
            Runnable task = this.scheduled.remove(expression);
            if (task != null) {
                return this.remove(task);
            }
            return false;
        }
    }
}

