/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library.items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.PointType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;

public class LocationItem
extends GenericItem {
    private static List<Class<? extends State>> acceptedDataTypes = new ArrayList<Class<? extends State>>();
    private static List<Class<? extends Command>> acceptedCommandTypes = new ArrayList<Class<? extends Command>>();

    static {
        acceptedDataTypes.add(PointType.class);
        acceptedDataTypes.add(UnDefType.class);
        acceptedCommandTypes.add(RefreshType.class);
        acceptedCommandTypes.add(PointType.class);
    }

    public LocationItem(String name) {
        super("Location", name);
    }

    public void send(PointType command) {
        this.internalSend(command);
    }

    @Override
    public List<Class<? extends State>> getAcceptedDataTypes() {
        return Collections.unmodifiableList(acceptedDataTypes);
    }

    @Override
    public List<Class<? extends Command>> getAcceptedCommandTypes() {
        return Collections.unmodifiableList(acceptedCommandTypes);
    }

    public DecimalType distanceFrom(LocationItem awayItem) {
        if (awayItem != null && awayItem.state instanceof PointType && this.state instanceof PointType) {
            PointType thisPoint = (PointType)this.state;
            PointType awayPoint = (PointType)awayItem.state;
            return thisPoint.distanceFrom(awayPoint);
        }
        return new DecimalType(-1L);
    }
}

