/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library.items;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.smarthome.core.library.items.SwitchItem;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.IncreaseDecreaseType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;

public class DimmerItem
extends SwitchItem {
    private static List<Class<? extends State>> acceptedDataTypes = new ArrayList<Class<? extends State>>();
    private static List<Class<? extends Command>> acceptedCommandTypes = new ArrayList<Class<? extends Command>>();

    static {
        acceptedDataTypes.add(OnOffType.class);
        acceptedDataTypes.add(PercentType.class);
        acceptedDataTypes.add(UnDefType.class);
        acceptedCommandTypes.add(OnOffType.class);
        acceptedCommandTypes.add(IncreaseDecreaseType.class);
        acceptedCommandTypes.add(PercentType.class);
        acceptedCommandTypes.add(RefreshType.class);
    }

    public DimmerItem(String name) {
        super("Dimmer", name);
    }

    DimmerItem(String type, String name) {
        super(type, name);
    }

    public void send(PercentType command) {
        this.internalSend(command);
    }

    @Override
    public List<Class<? extends State>> getAcceptedDataTypes() {
        return Collections.unmodifiableList(acceptedDataTypes);
    }

    @Override
    public List<Class<? extends Command>> getAcceptedCommandTypes() {
        return Collections.unmodifiableList(acceptedCommandTypes);
    }

    @Override
    public void setState(State state) {
        if (state == OnOffType.OFF) {
            super.setState(PercentType.ZERO);
        } else if (state == OnOffType.ON) {
            super.setState(PercentType.HUNDRED);
        } else if (state.getClass() == DecimalType.class) {
            super.setState(new PercentType(((DecimalType)state).toBigDecimal().multiply(new BigDecimal(100))));
        } else {
            super.setState(state);
        }
    }

    @Override
    public State getStateAs(Class<? extends State> typeClass) {
        if (this.state.getClass() == typeClass) {
            return this.state;
        }
        if (typeClass == OnOffType.class) {
            return this.state.equals(PercentType.ZERO) ? OnOffType.OFF : OnOffType.ON;
        }
        if (typeClass == DecimalType.class) {
            if (this.state instanceof PercentType) {
                return new DecimalType(((PercentType)this.state).toBigDecimal().divide(new BigDecimal(100), 8, RoundingMode.UP));
            }
        } else if (typeClass == PercentType.class && this.state instanceof DecimalType) {
            return new PercentType(((DecimalType)this.state).toBigDecimal().multiply(new BigDecimal(100)));
        }
        return super.getStateAs(typeClass);
    }
}

