/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library.items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.OpenClosedType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;

public class ContactItem
extends GenericItem {
    private static List<Class<? extends State>> acceptedDataTypes = new ArrayList<Class<? extends State>>();
    private static List<Class<? extends Command>> acceptedCommandTypes = new ArrayList<Class<? extends Command>>();

    static {
        acceptedDataTypes.add(OpenClosedType.class);
        acceptedDataTypes.add(UnDefType.class);
        acceptedCommandTypes.add(RefreshType.class);
    }

    public ContactItem(String name) {
        super("Contact", name);
    }

    @Override
    public List<Class<? extends State>> getAcceptedDataTypes() {
        return Collections.unmodifiableList(acceptedDataTypes);
    }

    @Override
    public List<Class<? extends Command>> getAcceptedCommandTypes() {
        return Collections.unmodifiableList(acceptedCommandTypes);
    }

    @Override
    public State getStateAs(Class<? extends State> typeClass) {
        if (typeClass == DecimalType.class) {
            return this.state == OpenClosedType.OPEN ? new DecimalType(1L) : DecimalType.ZERO;
        }
        if (typeClass == PercentType.class) {
            return this.state == OpenClosedType.OPEN ? PercentType.HUNDRED : PercentType.ZERO;
        }
        return super.getStateAs(typeClass);
    }
}

