/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library.items;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.smarthome.core.library.items.DimmerItem;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.HSBType;
import org.eclipse.smarthome.core.library.types.IncreaseDecreaseType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;

public class ColorItem
extends DimmerItem {
    private static List<Class<? extends State>> acceptedDataTypes = new ArrayList<Class<? extends State>>();
    private static List<Class<? extends Command>> acceptedCommandTypes = new ArrayList<Class<? extends Command>>();

    static {
        acceptedDataTypes.add(OnOffType.class);
        acceptedDataTypes.add(PercentType.class);
        acceptedDataTypes.add(HSBType.class);
        acceptedDataTypes.add(UnDefType.class);
        acceptedCommandTypes.add(OnOffType.class);
        acceptedCommandTypes.add(IncreaseDecreaseType.class);
        acceptedCommandTypes.add(PercentType.class);
        acceptedCommandTypes.add(HSBType.class);
        acceptedCommandTypes.add(RefreshType.class);
    }

    public ColorItem(String name) {
        super("Color", name);
    }

    public void send(HSBType command) {
        this.internalSend(command);
    }

    @Override
    public List<Class<? extends State>> getAcceptedDataTypes() {
        return Collections.unmodifiableList(acceptedDataTypes);
    }

    @Override
    public List<Class<? extends Command>> getAcceptedCommandTypes() {
        return Collections.unmodifiableList(acceptedCommandTypes);
    }

    @Override
    public void setState(State state) {
        State currentState = this.state;
        if (currentState instanceof HSBType) {
            DecimalType hue = ((HSBType)currentState).getHue();
            PercentType saturation = ((HSBType)currentState).getSaturation();
            if (state == OnOffType.OFF) {
                super.setState(new HSBType(hue, saturation, PercentType.ZERO));
            } else if (state == OnOffType.ON) {
                super.setState(new HSBType(hue, saturation, PercentType.HUNDRED));
            } else if (state instanceof PercentType && !(state instanceof HSBType)) {
                super.setState(new HSBType(hue, saturation, (PercentType)state));
            } else {
                super.setState(state);
            }
        } else if (state == OnOffType.OFF) {
            super.setState(HSBType.BLACK);
        } else if (state == OnOffType.ON) {
            super.setState(HSBType.WHITE);
        } else if (state instanceof PercentType && !(state instanceof HSBType)) {
            super.setState(new HSBType(DecimalType.ZERO, PercentType.ZERO, (PercentType)state));
        } else {
            super.setState(state);
        }
    }

    @Override
    public State getStateAs(Class<? extends State> typeClass) {
        if (typeClass == HSBType.class) {
            return this.state;
        }
        if (typeClass == OnOffType.class) {
            if (this.state instanceof HSBType) {
                HSBType hsbState = (HSBType)this.state;
                return hsbState.getBrightness().equals(PercentType.ZERO) ? OnOffType.OFF : OnOffType.ON;
            }
        } else if (typeClass == DecimalType.class) {
            if (this.state instanceof HSBType) {
                HSBType hsbState = (HSBType)this.state;
                return new DecimalType(hsbState.getBrightness().toBigDecimal().divide(new BigDecimal(100), 8, RoundingMode.UP));
            }
        } else if (typeClass == PercentType.class && this.state instanceof HSBType) {
            HSBType hsbState = (HSBType)this.state;
            return new PercentType(hsbState.getBrightness().toBigDecimal());
        }
        return super.getStateAs(typeClass);
    }
}

