/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.items.dto;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemFactory;
import org.eclipse.smarthome.core.items.dto.GroupItemDTO;
import org.eclipse.smarthome.core.items.dto.ItemDTO;

public class ItemDTOMapper {
    public static Item map(ItemDTO itemDTO, Set<ItemFactory> itemFactories) {
        Preconditions.checkArgument((itemDTO != null ? 1 : 0) != 0, (Object)"The argument 'itemDTO' must no be null.");
        Preconditions.checkArgument((itemFactories != null ? 1 : 0) != 0, (Object)"The argument 'itemFactories' must no be null.");
        GenericItem newItem = null;
        if (itemDTO.type != null) {
            if (itemDTO.type.equals("GroupItem")) {
                newItem = new GroupItem(itemDTO.name);
            } else {
                String itemType = itemDTO.type.substring(0, itemDTO.type.length() - 4);
                for (ItemFactory itemFactory : itemFactories) {
                    newItem = itemFactory.createItem(itemType, itemDTO.name);
                    if (newItem != null) break;
                }
            }
            if (newItem != null) {
                newItem.setLabel(itemDTO.label);
                newItem.setCategory(itemDTO.category);
                newItem.addGroupNames(itemDTO.groupNames);
                newItem.addTags(itemDTO.tags);
            }
        }
        return newItem;
    }

    public static ItemDTO map(Item item) {
        ItemDTO itemDTO = item instanceof GroupItem ? new GroupItemDTO() : new ItemDTO();
        ItemDTOMapper.fillProperties(itemDTO, item);
        return itemDTO;
    }

    private static void fillProperties(ItemDTO itemDTO, Item item) {
        if (item instanceof GroupItem) {
            GroupItem groupItem = (GroupItem)item;
            GroupItemDTO groupItemDTO = (GroupItemDTO)itemDTO;
            if (groupItem.getBaseItem() != null) {
                groupItemDTO.groupType = groupItem.getBaseItem().getType();
            }
        }
        itemDTO.name = item.getName();
        itemDTO.type = item.getClass().getSimpleName();
        itemDTO.label = item.getLabel();
        itemDTO.tags = item.getTags();
        itemDTO.category = item.getCategory();
        itemDTO.groupNames = item.getGroupNames();
    }
}

