/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.items;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.core.common.registry.AbstractManagedProvider;
import org.eclipse.smarthome.core.items.ActiveItem;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemFactory;
import org.eclipse.smarthome.core.items.ItemProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedItemProvider
extends AbstractManagedProvider<Item, String, PersistedItem>
implements ItemProvider {
    private static final String ITEM_TYPE_GROUP = "Group";
    private final Logger logger = LoggerFactory.getLogger(ManagedItemProvider.class);
    private Collection<ItemFactory> itemFactories = new CopyOnWriteArrayList<ItemFactory>();
    private final Map<String, PersistedItem> failedToCreate = new ConcurrentHashMap<String, PersistedItem>();

    public Item remove(String itemName, boolean recursive) {
        Item item = (Item)this.get(itemName);
        if (recursive && item instanceof GroupItem) {
            List<String> members = this.getMemberNamesRecursively((GroupItem)item, this.getAll());
            for (String member : members) {
                this.remove(member);
            }
        }
        if (item != null) {
            this.remove(item.getName());
            return item;
        }
        return null;
    }

    private List<String> getMemberNamesRecursively(GroupItem groupItem, Collection<Item> allItems) {
        ArrayList<String> memberNames = new ArrayList<String>();
        for (Item item : allItems) {
            if (!item.getGroupNames().contains(groupItem.getName())) continue;
            memberNames.add(item.getName());
            if (!(item instanceof GroupItem)) continue;
            memberNames.addAll(this.getMemberNamesRecursively((GroupItem)item, allItems));
        }
        return memberNames;
    }

    private GenericItem createItem(String itemType, String itemName) {
        for (ItemFactory factory : this.itemFactories) {
            GenericItem item = factory.createItem(itemType, itemName);
            if (item == null) continue;
            return item;
        }
        this.logger.debug("Couldn't find ItemFactory for item '{}' of type '{}'", (Object)itemName, (Object)itemType);
        return null;
    }

    private String toItemFactoryName(Item item) {
        return item.getType();
    }

    protected void addItemFactory(ItemFactory itemFactory) {
        this.itemFactories.add(itemFactory);
        if (this.failedToCreate.size() > 0) {
            Iterator<Map.Entry<String, PersistedItem>> iterator = this.failedToCreate.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, PersistedItem> entry = iterator.next();
                String itemName = entry.getKey();
                PersistedItem persistedItem = entry.getValue();
                GenericItem item = itemFactory.createItem(persistedItem.itemType, itemName);
                if (item != null) {
                    iterator.remove();
                    this.configureItem(persistedItem, item);
                    this.notifyListenersAboutAddedElement(item);
                    continue;
                }
                this.logger.debug("The added item factory '{}' still could not instantiate item '{}'.", (Object)itemFactory, (Object)itemName);
            }
            if (this.failedToCreate.isEmpty()) {
                this.logger.info("Finished loading the items which could not have been created before.");
            }
        }
    }

    @Override
    protected String getKey(Item element) {
        return element.getName();
    }

    @Override
    protected String getStorageName() {
        return Item.class.getName();
    }

    @Override
    protected String keyToString(String key) {
        return key;
    }

    protected void removeItemFactory(ItemFactory itemFactory) {
        this.itemFactories.remove(itemFactory);
    }

    @Override
    protected Item toElement(String itemName, PersistedItem persistedItem) {
        GenericItem item = null;
        if (persistedItem.itemType.equals(ITEM_TYPE_GROUP)) {
            if (persistedItem.baseItemType != null) {
                GenericItem baseItem = this.createItem(persistedItem.baseItemType, itemName);
                item = new GroupItem(itemName, baseItem);
            } else {
                item = new GroupItem(itemName);
            }
        } else {
            item = this.createItem(persistedItem.itemType, itemName);
        }
        this.configureItem(persistedItem, item);
        if (item == null) {
            this.failedToCreate.put(itemName, persistedItem);
            this.logger.debug("Couldn't restore item '{}' of type '{}' ~\u00a0there is no appropriate ItemFactory available.", (Object)itemName, (Object)persistedItem.itemType);
        }
        return item;
    }

    private void configureItem(PersistedItem persistedItem, ActiveItem item) {
        if (item != null) {
            Set<String> tags;
            List<String> groupNames = persistedItem.groupNames;
            if (groupNames != null) {
                for (String groupName : groupNames) {
                    item.addGroupName(groupName);
                }
            }
            if ((tags = persistedItem.tags) != null) {
                for (String tag : tags) {
                    item.addTag(tag);
                }
            }
            item.setLabel(persistedItem.label);
            item.setCategory(persistedItem.category);
        }
    }

    @Override
    protected PersistedItem toPersistableElement(Item item) {
        PersistedItem persistedItem = new PersistedItem();
        if (item instanceof GroupItem) {
            String baseItemType = null;
            GenericItem baseItem = ((GroupItem)item).getBaseItem();
            if (baseItem != null) {
                baseItemType = this.toItemFactoryName(baseItem);
            }
            persistedItem.itemType = ITEM_TYPE_GROUP;
            persistedItem.baseItemType = baseItemType;
        } else {
            String itemType;
            persistedItem.itemType = itemType = this.toItemFactoryName(item);
        }
        persistedItem.label = item.getLabel();
        persistedItem.groupNames = new ArrayList<String>(item.getGroupNames());
        persistedItem.tags = new HashSet<String>(item.getTags());
        persistedItem.category = item.getCategory();
        return persistedItem;
    }

    public static class PersistedItem {
        public String baseItemType;
        public List<String> groupNames;
        public String itemType;
        public Set<String> tags;
        public String label;
        public String category;
    }
}

