/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.i18n;

import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocaleProviderImpl
implements LocaleProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String LANGUAGE = "language";
    private final String SCRIPT = "script";
    private final String REGION = "region";
    private final String VARIANT = "variant";
    private Locale locale = Locale.getDefault();

    protected void activate(Map<String, Object> config) {
        this.modified(config);
    }

    protected void modified(Map<String, Object> config) {
        String language = (String)config.get("language");
        String script = (String)config.get("script");
        String region = (String)config.get("region");
        String variant = (String)config.get("variant");
        if (StringUtils.isEmpty((String)language)) {
            this.logger.info("LOCALE: no language is set, keep old: {}", (Object)this.locale);
            return;
        }
        Locale.Builder builder = new Locale.Builder();
        try {
            builder.setLanguage(language);
        }
        catch (RuntimeException ex) {
            this.logger.warn("Language ({}) is invalid. Cannot create locale, keep old one.", (Object)language, (Object)ex);
            return;
        }
        try {
            builder.setScript(script);
        }
        catch (RuntimeException ex) {
            this.logger.warn("Script ({}) is invalid. Skip it.", (Object)script, (Object)ex);
            return;
        }
        try {
            builder.setRegion(region);
        }
        catch (RuntimeException ex) {
            this.logger.warn("Region ({}) is invalid. Skip it.", (Object)region, (Object)ex);
            return;
        }
        try {
            builder.setVariant(variant);
        }
        catch (RuntimeException ex) {
            this.logger.warn("Variant ({}) is invalid. Skip it.", (Object)variant, (Object)ex);
            return;
        }
        this.locale = builder.build();
        this.logger.info("LOCALE: new locale set: {}", (Object)this.locale);
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }
}

