/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.events;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import java.util.Set;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventFactory;

public abstract class AbstractEventFactory
implements EventFactory {
    private final Set<String> supportedEventTypes;
    private static final Gson jsonConverter = new Gson();

    public AbstractEventFactory(Set<String> supportedEventTypes) {
        this.supportedEventTypes = ImmutableSet.copyOf(supportedEventTypes);
    }

    @Override
    public Event createEvent(String eventType, String topic, String payload, String source) throws Exception {
        this.assertValidArguments(eventType, topic, payload);
        if (!this.getSupportedEventTypes().contains(eventType)) {
            throw new IllegalArgumentException("The event type '" + eventType + "' is not supported by this factory.");
        }
        return this.createEventByType(eventType, topic, payload, source);
    }

    @Override
    public Set<String> getSupportedEventTypes() {
        return this.supportedEventTypes;
    }

    private void assertValidArguments(String eventType, String topic, String payload) {
        Preconditions.checkArgument((eventType != null && !eventType.isEmpty() ? 1 : 0) != 0, (Object)"The argument 'eventType' must not be null or empty.");
        Preconditions.checkArgument((topic != null && !topic.isEmpty() ? 1 : 0) != 0, (Object)"The argument 'topic' must not be null or empty.");
        Preconditions.checkArgument((payload != null && !payload.isEmpty() ? 1 : 0) != 0, (Object)"The argument 'payload' must not be null or empty.");
    }

    protected abstract Event createEventByType(String var1, String var2, String var3, String var4) throws Exception;

    protected static String serializePayload(Object payloadObject) {
        return jsonConverter.toJson(payloadObject);
    }

    protected static <T> T deserializePayload(String payload, Class<T> classOfPayload) {
        return (T)jsonConverter.fromJson(payload, classOfPayload);
    }

    protected String[] getTopicElements(String topic) {
        return topic.split("/");
    }
}

