/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.common.osgi;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceBinder {
    private ServiceTracker<?, ?> serviceTracker;
    private Object trackedService;
    private Logger logger = LoggerFactory.getLogger(ServiceBinder.class);

    public ServiceBinder(final BundleContext bundleContext, final Object targetObject) throws IllegalArgumentException {
        if (bundleContext == null) {
            throw new IllegalArgumentException("The bundle context must not be null!");
        }
        if (targetObject == null) {
            throw new IllegalArgumentException("The target object to be invoked must not be null!");
        }
        final Method bindMethod = this.findAnnotatedMethod(targetObject, Bind.class);
        if (bindMethod == null) {
            throw new IllegalArgumentException("The annotated bind method is missing!");
        }
        Class<?> serviceClazz = this.determineServiceType(bindMethod, true);
        final Method unbindMethod = this.findAnnotatedMethod(targetObject, Unbind.class);
        Class<?> serviceUnbindClazz = this.determineServiceType(unbindMethod, false);
        if (serviceUnbindClazz != null && serviceUnbindClazz != serviceClazz) {
            throw new IllegalArgumentException("The unbind method uses a wrong parameter type!");
        }
        this.serviceTracker = new ServiceTracker(bundleContext, serviceClazz.getName(), new ServiceTrackerCustomizer<Class<?>, Object>(){

            public synchronized Object addingService(ServiceReference<Class<?>> reference) {
                Object service = bundleContext.getService(reference);
                if (ServiceBinder.this.trackedService == null && service != null) {
                    ServiceBinder.this.trackedService = service;
                    ServiceBinder.this.injectService(bindMethod, targetObject, service);
                    return service;
                }
                return null;
            }

            public void modifiedService(ServiceReference<Class<?>> reference, Object service) {
            }

            public synchronized void removedService(ServiceReference<Class<?>> reference, Object service) {
                if (service == ServiceBinder.this.trackedService) {
                    ServiceBinder.this.trackedService = null;
                    if (bindMethod.equals(unbindMethod)) {
                        ServiceBinder.this.injectService(unbindMethod, targetObject, null);
                    } else {
                        ServiceBinder.this.injectService(unbindMethod, targetObject, service);
                    }
                }
            }
        });
    }

    public void open() {
        this.serviceTracker.open();
    }

    public void close() {
        this.serviceTracker.close();
    }

    private Method findAnnotatedMethod(Object object, Class<? extends Annotation> annotationClass) throws IllegalArgumentException {
        Method[] methods;
        Method[] methodArray = methods = object.getClass().getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(annotationClass)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    private Class<?> determineServiceType(Method method, boolean required) throws IllegalArgumentException {
        if (method != null) {
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length == 1) {
                return paramTypes[0];
            }
            if (paramTypes.length > 1) {
                throw new IllegalArgumentException("The annotated method '" + method.getName() + "' must contain one and only one parameter!");
            }
            if (required) {
                throw new IllegalArgumentException("The annotated method '" + method.getName() + "' must contain one parameter!");
            }
        }
        return null;
    }

    private void injectService(Method method, Object object, Object service) {
        if (method != null) {
            try {
                if (method.getParameterTypes().length == 1) {
                    method.invoke(object, service);
                } else {
                    method.invoke(object, new Object[0]);
                }
            }
            catch (Exception ex) {
                this.logger.error("Error while executing inject method: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Bind {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Unbind {
    }
}

