/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.binding;

import java.net.URI;

public class BindingInfo {
    public static final String DEFAULT_SERVICE_ID_PREFIX = "binding.";
    private String id;
    private String name;
    private String description;
    private String author;
    private URI configDescriptionURI;
    private String serviceId;

    public BindingInfo(String id, String name, String description, String author, String serviceId, URI configDescriptionURI) throws IllegalArgumentException {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("The ID must neither be null nor empty!");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The name must neither be null nor empty!");
        }
        this.id = id;
        this.name = name;
        this.description = description;
        this.author = author;
        this.serviceId = serviceId != null ? serviceId : DEFAULT_SERVICE_ID_PREFIX + id;
        this.configDescriptionURI = configDescriptionURI;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAuthor() {
        return this.author;
    }

    public boolean hasConfigDescriptionURI() {
        return this.configDescriptionURI != null;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public URI getConfigDescriptionURI() {
        return this.configDescriptionURI;
    }

    public String toString() {
        return "BindingInfoImpl [id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", author=" + this.author + ", configDescriptionURI=" + this.configDescriptionURI + "]";
    }
}

